/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.security.SecureRandom;
import org.bouncycastle.crypto.digests.SHA512Digest;
import org.bouncycastle.crypto.prng.SP800SecureRandom;
import org.bouncycastle.crypto.prng.SP800SecureRandomBuilder;
import org.bouncycastle.tls.crypto.TlsNonceGenerator;

class JcaNonceGenerator
implements TlsNonceGenerator {
    private final SP800SecureRandom random;

    JcaNonceGenerator(SecureRandom secureRandom, byte[] byArray) {
        byte[] byArray2 = new byte[32];
        secureRandom.nextBytes(byArray2);
        this.random = new SP800SecureRandomBuilder(secureRandom, false).setPersonalizationString(byArray).buildHash(new SHA512Digest(), byArray2, false);
    }

    public byte[] generateNonce(int n) {
        byte[] byArray = new byte[n];
        this.random.nextBytes(byArray);
        return byArray;
    }
}

