/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedKeyManager;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.TBSCertificate;
import org.bouncycastle.jsse.provider.JsseUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ProvX509KeyManager
extends X509ExtendedKeyManager {
    private final List<KeyStore.Builder> builders;
    private final Map<String, KeyStore.PrivateKeyEntry> keys = new HashMap<String, KeyStore.PrivateKeyEntry>();
    private final AtomicLong version = new AtomicLong();

    public ProvX509KeyManager(List<KeyStore.Builder> list) {
        this.builders = list;
    }

    @Override
    public String chooseClientAlias(String[] stringArray, Principal[] principalArray, Socket socket) {
        return this.chooseAlias(false, stringArray, principalArray);
    }

    @Override
    public String chooseEngineClientAlias(String[] stringArray, Principal[] principalArray, SSLEngine sSLEngine) {
        return this.chooseAlias(false, stringArray, principalArray);
    }

    @Override
    public String chooseEngineServerAlias(String string, Principal[] principalArray, SSLEngine sSLEngine) {
        return this.chooseAlias(true, new String[]{string}, principalArray);
    }

    @Override
    public String chooseServerAlias(String string, Principal[] principalArray, Socket socket) {
        return this.chooseAlias(true, new String[]{string}, principalArray);
    }

    @Override
    public X509Certificate[] getCertificateChain(String string) {
        KeyStore.PrivateKeyEntry privateKeyEntry = this.getPrivateKeyEntry(string);
        return privateKeyEntry == null ? null : (X509Certificate[])privateKeyEntry.getCertificateChain();
    }

    @Override
    public String[] getClientAliases(String string, Principal[] principalArray) {
        return this.getAliases(false, string, principalArray);
    }

    @Override
    public PrivateKey getPrivateKey(String string) {
        KeyStore.PrivateKeyEntry privateKeyEntry = this.getPrivateKeyEntry(string);
        return privateKeyEntry == null ? null : privateKeyEntry.getPrivateKey();
    }

    @Override
    public String[] getServerAliases(String string, Principal[] principalArray) {
        return this.getAliases(true, string, principalArray);
    }

    private String chooseAlias(boolean bl, String[] stringArray, Principal[] principalArray) {
        try {
            Set<X500Name> set = JsseUtils.toX500Names(principalArray);
            for (int i = 0; i != stringArray.length; ++i) {
                List<String> list = this.findAliases(bl, stringArray[i], set);
                if (list.isEmpty()) continue;
                return list.get(0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private List<String> findAliases(boolean bl, String string, Set<X500Name> set) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i != this.builders.size(); ++i) {
            KeyStore.Builder builder = this.builders.get(i);
            try {
                arrayList.addAll(this.findAliases(bl, i, builder.getKeyStore(), builder, string, set));
                continue;
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new IllegalStateException("unable to build key store: " + generalSecurityException.getMessage(), generalSecurityException);
            }
        }
        return arrayList;
    }

    private List<String> findAliases(boolean bl, int n, KeyStore keyStore, KeyStore.Builder builder, String string, Set<X500Name> set) throws GeneralSecurityException {
        ArrayList<String> arrayList = new ArrayList<String>();
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            X509Certificate[] x509CertificateArray;
            String string2 = enumeration.nextElement();
            if (!keyStore.isKeyEntry(string2) || (x509CertificateArray = JsseUtils.getX509CertificateChain(keyStore.getCertificateChain(string2))) == null || x509CertificateArray.length == 0 || !this.isSuitableCredential(bl, string, set, x509CertificateArray)) continue;
            KeyStore.PrivateKeyEntry privateKeyEntry = (KeyStore.PrivateKeyEntry)keyStore.getEntry(string2, builder.getProtectionParameter(string2));
            String string3 = n + "." + string2 + "." + this.version.getAndIncrement();
            this.keys.put(string3, privateKeyEntry);
            arrayList.add(string3);
        }
        return arrayList;
    }

    private String[] getAliases(boolean bl, String string, Principal[] principalArray) {
        List<String> list = this.findAliases(bl, string, JsseUtils.toX500Names(principalArray));
        return list.toArray(new String[list.size()]);
    }

    private KeyStore.PrivateKeyEntry getPrivateKeyEntry(String string) {
        return string == null ? null : this.keys.get(string);
    }

    private boolean hasSuitableIssuer(Set<X500Name> set, X509Certificate x509Certificate) {
        return set.contains(JsseUtils.toX500Name(x509Certificate.getIssuerX500Principal()));
    }

    private boolean isSuitableCredential(boolean bl, String string, Set<X500Name> set, X509Certificate[] x509CertificateArray) {
        if (!this.isSuitableCertificate(bl, string, x509CertificateArray[0])) {
            return false;
        }
        if (set == null || set.isEmpty()) {
            return true;
        }
        int n = x509CertificateArray.length;
        while (--n >= 0) {
            if (!this.hasSuitableIssuer(set, x509CertificateArray[n])) continue;
            return true;
        }
        return false;
    }

    private boolean isSuitableCertificate(boolean bl, String string, X509Certificate x509Certificate) {
        if (string == null || x509Certificate == null) {
            return false;
        }
        PublicKey publicKey = x509Certificate.getPublicKey();
        if (string.equalsIgnoreCase("DHE_RSA") || string.equalsIgnoreCase("ECDHE_RSA") || string.equalsIgnoreCase("SRP_RSA")) {
            return publicKey instanceof RSAPublicKey && this.isSuitableKeyUsage(128, x509Certificate);
        }
        if (string.equalsIgnoreCase("DHE_DSS") || string.equalsIgnoreCase("SRP_DSS")) {
            return publicKey instanceof DSAPublicKey && this.isSuitableKeyUsage(128, x509Certificate);
        }
        if (string.equalsIgnoreCase("ECDHE_ECDSA")) {
            return publicKey instanceof ECPublicKey && this.isSuitableKeyUsage(128, x509Certificate);
        }
        if (string.equalsIgnoreCase("RSA")) {
            int n = bl ? 32 : 128;
            return publicKey instanceof RSAPublicKey && this.isSuitableKeyUsage(n, x509Certificate);
        }
        if (string.equalsIgnoreCase("DSA")) {
            return !bl && publicKey instanceof DSAPublicKey && this.isSuitableKeyUsage(128, x509Certificate);
        }
        if (string.equalsIgnoreCase("EC")) {
            return publicKey instanceof ECPublicKey && this.isSuitableKeyUsage(128, x509Certificate);
        }
        return false;
    }

    private boolean isSuitableKeyUsage(int n, X509Certificate x509Certificate) {
        try {
            int n2;
            KeyUsage keyUsage;
            Extensions extensions = TBSCertificate.getInstance(x509Certificate.getTBSCertificate()).getExtensions();
            if (extensions != null && (keyUsage = KeyUsage.fromExtensions(extensions)) != null && ((n2 = keyUsage.getBytes()[0] & 0xFF) & n) != n) {
                return false;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }
}

