/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.edec.examples.ws;

import ch.admin.bit.edec.examples.PropertyProvider;
import ch.admin.bit.edec.examples.ws.AbstractRequest;
import ch.admin.bit.edec.examples.ws.ConnectionParams;
import ch.admin.bit.edec.examples.ws.HttpRequest;
import ch.admin.bit.edec.examples.ws.HttpsRequest;
import ch.admin.bit.edec.examples.ws.SslConnectionParams;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import javax.net.ssl.HttpsURLConnection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SOAPRequest {
    private static final long serialVersionUID = 99887733L;
    private static final Log log = LogFactory.getLog(HttpsRequest.class);
    private Writer wr = null;
    private BufferedReader rd = null;
    private HttpURLConnection connection = null;
    private HttpsURLConnection sslConnection = null;
    private String formatedResponse = "";
    private URLConnection uc = null;

    public String sendRequest(ConnectionParams params) {
        String response = null;
        try {
            URL url = null;
            try {
                url = SOAPRequest.getUrl(params);
            }
            catch (MalformedURLException e) {
                log.error("Couldn't open a connection! " + e.getMessage());
            }
            params.setUrl(url);
            if (params.getProtocol().toLowerCase().equals("http")) {
                log.info("HTTP");
                HttpRequest.doRequest(params);
            } else {
                log.info("HTTPS");
                SslConnectionParams sslConnectionParams = new SslConnectionParams(params);
                sslConnectionParams.setKeystorePath(PropertyProvider.getProperty("ws.keystore.path"));
                sslConnectionParams.setKeystorePassword(PropertyProvider.getProperty("ws.keystore.password"));
                sslConnectionParams.setTruststorePath(PropertyProvider.getProperty("ws.truststore.path"));
                sslConnectionParams.setTruststorePassword(PropertyProvider.getProperty("ws.truststore.password"));
                sslConnectionParams.setIdentityPassword(PropertyProvider.getProperty("identity.password"));
                response = HttpsRequest.doRequest(sslConnectionParams);
            }
            if (null != response) {
                log.debug("Response received [size=" + response.length() + "]");
            } else {
                log.debug("No response received!");
            }
        }
        catch (IOException ioe) {
            log.error("AbstractRequest failed! " + ioe.getMessage());
            log.debug("Received IOException:" + AbstractRequest.SEP + "Exception Message: " + ioe.getMessage());
        }
        return response;
    }

    private static URL getUrl(ConnectionParams params) throws MalformedURLException {
        StringBuilder pathAndQuery = new StringBuilder();
        String path = params.getPath();
        if (!path.startsWith("/")) {
            pathAndQuery.append("/");
        }
        pathAndQuery.append(path);
        String protocol = params.getProtocol();
        String server = params.getHost();
        int port = 0;
        try {
            port = params.getPort();
        }
        catch (NumberFormatException e) {
            log.error("invalid port argument: " + e.getMessage() + AbstractRequest.SEP + " Using default port 80.");
            port = 80;
        }
        return new URL(protocol, server, port, pathAndQuery.toString());
    }
}

