/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.edec.examples.fileHandling;

import ch.admin.bit.edec.examples.EdecRequestResponse;
import ch.admin.bit.edec.examples.EdecRequestType;
import ch.admin.bit.edec.examples.PropertyProvider;
import ch.admin.bit.edec.examples.fileHandling.FileHandlerException;
import ch.admin.bit.edec.examples.ws.HttpsRequest;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class FileHandler {
    private static final Log log = LogFactory.getLog(HttpsRequest.class);
    public static final String SOAP_REPLACEMENT_STRING = "###PLACEHOLDER###";

    public static String loadTextFile(String fileName) throws FileHandlerException {
        BufferedReader br = null;
        FileReader fr = null;
        StringBuilder file = new StringBuilder();
        try {
            String sCurrentLine;
            fr = new FileReader(fileName);
            br = new BufferedReader(fr);
            while ((sCurrentLine = br.readLine()) != null) {
                file.append(sCurrentLine);
            }
        }
        catch (IOException e) {
            throw new FileHandlerException("Couldn't load file", e);
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
                if (fr != null) {
                    fr.close();
                }
            }
            catch (IOException ex) {
                throw new FileHandlerException("Couldn't load file", ex);
            }
        }
        return file.toString();
    }

    public static String loadTextResource(String fileName) throws FileHandlerException {
        String path = Thread.currentThread().getContextClassLoader().getResource(fileName).getPath();
        return FileHandler.loadTextFile(path);
    }

    public static EdecRequestResponse loadXmlFile(String fileName) throws FileHandlerException {
        String xml = FileHandler.loadTextFile(fileName);
        String soapEnvelope = FileHandler.loadTextResource(PropertyProvider.getProperty("request.soap.envelope"));
        String fullRequest = soapEnvelope.replace(SOAP_REPLACEMENT_STRING, xml);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        Document doc = null;
        EdecRequestType type = null;
        try {
            builder = factory.newDocumentBuilder();
            InputSource is = new InputSource(new StringReader(xml));
            doc = builder.parse(is);
            if (null != doc && null != doc.getLastChild()) {
                String ndType = doc.getLastChild().getNodeName();
                type = ndType.contains(EdecRequestType.TYPE_EDEC.getName()) ? EdecRequestType.TYPE_EDEC : (ndType.contains(EdecRequestType.TYPE_BORDEREAU.getName()) ? EdecRequestType.TYPE_BORDEREAU : (ndType.contains(EdecRequestType.TYPE_RECEIPT.getName()) ? EdecRequestType.TYPE_RECEIPT : null));
            }
        }
        catch (ParserConfigurationException e) {
            throw new FileHandlerException("Couldn't load file", e);
        }
        catch (SAXException e) {
            throw new FileHandlerException("Couldn't load file", e);
        }
        catch (IOException e) {
            throw new FileHandlerException("Couldn't load file", e);
        }
        EdecRequestResponse request = new EdecRequestResponse(fullRequest, type);
        return request;
    }

    public static void saveXmlFile(String fileName, String content) throws FileHandlerException {
        try {
            FileUtils.writeStringToFile(new File(fileName), content, "utf-8");
        }
        catch (IOException e) {
            log.error("Couldn't write file! ", e);
            throw new FileHandlerException("Couldn't write file! ", e);
        }
    }

    public static KeyStore loadStore(InputStream storeStream, String storePassword) {
        char[] password = storePassword.toCharArray();
        KeyStore store = null;
        try {
            store = KeyStore.getInstance(KeyStore.getDefaultType());
            store.load(storeStream, password);
        }
        catch (CertificateException e) {
            log.error(e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            log.error(e.getMessage());
        }
        catch (KeyStoreException e) {
            log.error(e.getMessage());
        }
        catch (IOException e) {
            log.error(e.getMessage());
        }
        return store;
    }
}

