/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.edec.examples;

import ch.admin.bit.edec.examples.EdecRequestResponse;
import ch.admin.bit.edec.examples.EdecRequestType;
import ch.admin.bit.edec.examples.PropertyProvider;
import ch.admin.bit.edec.examples.fileHandling.FileHandler;
import ch.admin.bit.edec.examples.fileHandling.FileHandlerException;
import ch.admin.bit.edec.examples.ws.ConnectionParams;
import ch.admin.bit.edec.examples.ws.HttpsRequest;
import ch.admin.bit.edec.examples.ws.SOAPRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RequestSender {
    private static final Log log = LogFactory.getLog(HttpsRequest.class);

    public static String sendRequest(String fileName) {
        EdecRequestResponse request = null;
        EdecRequestResponse response = null;
        try {
            request = FileHandler.loadXmlFile(fileName);
        }
        catch (FileHandlerException e1) {
            e1.printStackTrace();
        }
        if (null == request) {
            return null;
        }
        ConnectionParams params = RequestSender.createConnectionParams();
        params.setRequest(request.getContent());
        EdecRequestType type = request.getType();
        if (type.isEdec()) {
            response = RequestSender.sendEdecRequest(params);
        } else if (type.isBordereau()) {
            response = RequestSender.sendBordereauRequest(params);
        } else if (type.isReceipt()) {
            response = RequestSender.sendReceiptRequest(params);
        } else {
            return null;
        }
        return response.getContent();
    }

    private static EdecRequestResponse sendEdecRequest(ConnectionParams params) {
        SOAPRequest soapRequest = new SOAPRequest();
        params.setPath(PropertyProvider.getProperty("ws.path.edec"));
        String xmlResponse = soapRequest.sendRequest(params);
        EdecRequestResponse response = new EdecRequestResponse(xmlResponse, EdecRequestType.TYPE_EDEC);
        return response;
    }

    private static EdecRequestResponse sendBordereauRequest(ConnectionParams params) {
        SOAPRequest soapRequest = new SOAPRequest();
        params.setPath(PropertyProvider.getProperty("ws.path.bordereau"));
        String xmlResponse = soapRequest.sendRequest(params);
        EdecRequestResponse response = new EdecRequestResponse(xmlResponse, EdecRequestType.TYPE_RECEIPT);
        return response;
    }

    private static EdecRequestResponse sendReceiptRequest(ConnectionParams params) {
        SOAPRequest soapRequest = new SOAPRequest();
        params.setPath(PropertyProvider.getProperty("ws.path.receipt"));
        String xmlResponse = soapRequest.sendRequest(params);
        EdecRequestResponse response = new EdecRequestResponse(xmlResponse, EdecRequestType.TYPE_RECEIPT);
        return response;
    }

    private static ConnectionParams createConnectionParams() {
        ConnectionParams params = new ConnectionParams();
        params.setSslHeaderAddition(PropertyProvider.getProperty("ws.ssl.header.addition"));
        params.setHost(PropertyProvider.getProperty("ws.host"));
        params.setPort(Integer.valueOf(PropertyProvider.getProperty("ws.port")));
        params.setRequestMethod("POST");
        params.setSoapAction(PropertyProvider.getProperty("ws.soap.action"));
        params.setProtocol(PropertyProvider.getProperty("ws.protocol"));
        return params;
    }
}

