/*
 *  Name:    $Id: EditPopupMenuMouseListener.java,v 1.1 2010/02/01 10:29:12 t724w Exp $
 * 
 *  Copyright 2009 Bundesamt für Informatik und Telekommunikation
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package ch.admin.bit.edec.evv.ui.swing;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

import javax.swing.text.JTextComponent;

/**
 * Mouselistener which displays the {@link EditPopupMenu}
 * 
 * @author mru
 * 
 */
public class EditPopupMenuMouseListener extends MouseAdapter {

	@Override
	public void mousePressed(MouseEvent e) {
		maybeShowPopup(e);
	}

	@Override
	public void mouseReleased(MouseEvent e) {
		maybeShowPopup(e);
	}

	private void maybeShowPopup(MouseEvent e) {

		if (e.isPopupTrigger()) {
			if (e.getSource() instanceof JTextComponent) {

				JTextComponent comp = (JTextComponent) e.getSource();
				EditPopupMenu popupMenu = new EditPopupMenu(comp);
				popupMenu.show(comp, e.getX(), e.getY());
			}
		}
	}

}
