/*
 *  Name:    $Id: MultipleOutputter.java,v 1.3 2010/03/02 16:01:39 t724w Exp $
 * 
 *  Copyright 2009 Bundesamt für Informatik und Telekommunikation
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package ch.admin.bit.edec.dsig.out;

import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;

import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * This {@link OutputterStrategy} can have multiple {@link OutputterStrategy}s
 * to which a output should written.
 * 
 * @author t724w (mru)
 * 
 */
public class MultipleOutputter implements OutputterStrategy {

	public List<OutputterStrategy> outList = new ArrayList<OutputterStrategy>();

	/**
	 * Add an {@link OutputterStrategy}
	 * 
	 * @param outputter
	 */
	public void addOutputter(OutputterStrategy outputter) {
		this.outList.add(outputter);
	}

	public void write(String str) {
		for (OutputterStrategy outputterStrategy : outList) {
			outputterStrategy.write(str);
		}
	}

	public void write(String prefix, X509Certificate cert) {
		for (OutputterStrategy outputterStrategy : outList) {
			outputterStrategy.write(prefix, cert);
		}
	}

	public void write(String prefix, X509CRL crl) {
		for (OutputterStrategy outputterStrategy : outList) {
			outputterStrategy.write(prefix, crl);
		}
	}

	public void write(NodeList list) {
		for (OutputterStrategy outputterStrategy : outList) {
			outputterStrategy.write(list);
		}
	}

	public void write(Node node) {
		for (OutputterStrategy outputterStrategy : outList) {
			outputterStrategy.write(node);
		}
	}

	public void write(String prefix, Throwable ex) {
		for (OutputterStrategy outputterStrategy : outList) {
			outputterStrategy.write(prefix, ex);
		}
	}

	public void close() {
		for (OutputterStrategy outputterStrategy : outList) {
			outputterStrategy.close();
		}
	}

}
