/*
 *  Name:    $Id: SystemContext.java,v 1.2 2010/01/07 14:57:52 t724w Exp $
 *
 *  Copyright 2009 Bundesamt fr Informatik und Telekommunikation
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package ch.admin.bit.edec.dsig.context;

import ch.admin.bit.edec.dsig.out.OutputterStrategy;

/**
 * The {@link SystemContext} provides access to some core functionality.
 *
 * @author t724w (mru)
 */
public interface SystemContext {

  /**
   * Get the default {@link OutputterStrategy}
   *
   * @return the default {@link OutputterStrategy}
   */
  OutputterStrategy getOutputterStrategy();

  /**
   * Get the default {@link ProviderSelector}
   *
   * @return the deafult {@link ProviderSelector}
   */
  ProviderSelector getProviderSelector();

}
