/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.edec.evv.ui.swing;

import ch.admin.bit.edec.dsig.Environment;
import ch.admin.bit.edec.evv.ui.swing.FileInputChangedListener;
import ch.admin.bit.edec.evv.ui.swing.FileInputPanel;
import ch.admin.bit.edec.evv.ui.swing.FileInputType;
import ch.admin.bit.edec.evv.ui.swing.OperationPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Properties;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class MainApp
extends JFrame
implements FileInputChangedListener {
    private int width = 580;
    private int height = 520;
    private String evv = "";
    private String ca = "";
    private String crl = "";
    private boolean saveConfig = false;
    private String iconPath = "/icon.png";
    private static final long serialVersionUID = 1L;

    public MainApp() {
        this.setLayout(new BorderLayout());
        this.loadConfig();
        this.setDefaultCloseOperation(3);
        this.setTitle("eVV Validator GUI " + Environment.getVersion());
        Image icon = Environment.getImage(this.iconPath);
        if (icon != null) {
            this.setIconImage(icon);
        }
        this.setJMenuBar(this.createMenu(this));
        OperationPanel opPanel = new OperationPanel(this);
        ArrayList<FileInputChangedListener> listeners = new ArrayList<FileInputChangedListener>();
        listeners.add(this);
        listeners.add(opPanel);
        JPanel north = new JPanel(new GridLayout(0, 1));
        north.add(new FileInputPanel(FileInputType.EVV, this.evv, listeners));
        north.add(new FileInputPanel(FileInputType.CRL, this.crl, listeners));
        north.add(new FileInputPanel(FileInputType.CA, this.ca, listeners));
        this.add((Component)north, "North");
        this.add((Component)opPanel, "Center");
        this.setSize(this.width, this.height);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                MainApp.this.height = e.getWindow().getHeight();
                MainApp.this.width = e.getWindow().getWidth();
                MainApp.this.saveConfig();
            }
        });
    }

    private void loadConfig() {
        String configLAF;
        String configHeight;
        String configWidth;
        String configEVV;
        String configCRL;
        Properties properties = Environment.loadConfig();
        String configCA = properties.getProperty(Environment.CA);
        if (configCA != null) {
            this.ca = configCA;
        }
        if ((configCRL = properties.getProperty(Environment.CRL)) != null) {
            this.crl = configCRL;
        }
        if ((configEVV = properties.getProperty(Environment.EVV)) != null) {
            this.evv = configEVV;
        }
        if ((configWidth = properties.getProperty(Environment.WINDOW_WIDTH)) != null) {
            try {
                this.width = Integer.valueOf(configWidth);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((configHeight = properties.getProperty(Environment.WINDOW_HEIGHT)) != null) {
            try {
                this.height = Integer.valueOf(configHeight);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((configLAF = properties.getProperty(Environment.LAF)) != null) {
            try {
                UIManager.setLookAndFeel(configLAF);
            }
            catch (Exception e) {
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        } else {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void saveConfig() {
        if (!this.saveConfig) {
            return;
        }
        Properties properties = new Properties();
        properties.setProperty(Environment.CA, this.ca);
        properties.setProperty(Environment.CRL, this.crl);
        properties.setProperty(Environment.EVV, this.evv);
        properties.setProperty(Environment.WINDOW_HEIGHT, String.valueOf(this.height));
        properties.setProperty(Environment.WINDOW_WIDTH, String.valueOf(this.width));
        properties.setProperty(Environment.LAF, UIManager.getLookAndFeel().getClass().getName());
        Environment.saveConfig(properties);
    }

    @Override
    public void onFilePathChanged(String path, FileInputType source) {
        switch (source) {
            case CA: {
                this.ca = path;
                break;
            }
            case CRL: {
                this.crl = path;
                break;
            }
            case EVV: {
                this.evv = path;
                break;
            }
        }
    }

    public void setSaveConfig(boolean saveConfig) {
        this.saveConfig = saveConfig;
    }

    public JMenuBar createMenu(final JFrame parent) {
        UIManager.LookAndFeelInfo[] lafs;
        JMenuBar bar = new JMenuBar();
        JMenu infoMenu = new JMenu("Info");
        JMenuItem about = new JMenuItem("About eVV Validator");
        infoMenu.add(about);
        about.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Image image = Environment.getImage(MainApp.this.iconPath);
                String title = "e-dec eVV Validator " + Environment.getVersion();
                String text = "You will find more information about e-dec on the swiss customs homepage (http://www.ezv.admin.ch)";
                text = text + Environment.getLicense();
                if (image != null) {
                    ImageIcon icon = new ImageIcon(image);
                    JOptionPane.showMessageDialog(parent, text, title, 1, icon);
                } else {
                    JOptionPane.showMessageDialog(parent, text, title, 1);
                }
            }
        });
        JMenu lafMenu = new JMenu("Look'n'Feel");
        for (final UIManager.LookAndFeelInfo lafInfo : lafs = UIManager.getInstalledLookAndFeels()) {
            String text = lafInfo.getName();
            JMenuItem item = new JMenuItem(text);
            lafMenu.add(item);
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        UIManager.setLookAndFeel(lafInfo.getClassName());
                        MainApp.this.saveConfig();
                        SwingUtilities.updateComponentTreeUI(MainApp.this.getRootFrame());
                        MainApp.this.getRootFrame().pack();
                    }
                    catch (Exception ex) {
                        System.err.println(ex);
                    }
                }
            });
        }
        bar.add(infoMenu);
        bar.add(lafMenu);
        return bar;
    }

    private JFrame getRootFrame() {
        return this;
    }
}

