/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.edec.evv.ui;

import ch.admin.bit.edec.dsig.ValidationResult;
import ch.admin.bit.edec.dsig.ValidationResultImpl;
import ch.admin.bit.edec.dsig.builder.X509CRLBuilder;
import ch.admin.bit.edec.dsig.builder.X509CertificateBuilder;
import ch.admin.bit.edec.dsig.context.ProviderSelectorImpl;
import ch.admin.bit.edec.dsig.context.SystemContext;
import ch.admin.bit.edec.dsig.context.SystemContextImpl;
import ch.admin.bit.edec.dsig.out.ConsoleOutputter;
import ch.admin.bit.edec.dsig.out.FileOutputter;
import ch.admin.bit.edec.dsig.out.MultipleOutputter;
import ch.admin.bit.edec.dsig.out.OutputterStrategy;
import ch.admin.bit.edec.dsig.util.XMLUtil;
import ch.admin.bit.edec.dsig.validator.X509CertificateValidator;
import ch.admin.bit.edec.dsig.validator.XMLSignatureValidator;
import java.io.File;
import java.io.FileNotFoundException;
import java.security.cert.CertificateException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class EVVValidator {
    private static final String HELP_FILE_TXT = "/help.txt";
    private List<OutputterStrategy> outputterStrategies = new ArrayList<OutputterStrategy>();
    private static final String SUFIX_XML = ".xml";
    private static boolean showSystemInfo = true;
    private static EVVValidator evvValidator;

    public static void main(String[] args) {
        evvValidator = new EVVValidator();
        DefaultParser parser = new DefaultParser();
        Options options = evvValidator.getCommandLineOptions();
        String inputCA = null;
        String inputCRL = null;
        String inputFile = null;
        String inputDate = null;
        String inputDir = null;
        String outputDir = null;
        boolean move = false;
        boolean showDebugInfos = false;
        try {
            CommandLine line = parser.parse(options, args);
            if (null == line.getOptions()) {
                EVVValidator.showHelp(options);
                System.exit(1);
            }
            if (line.hasOption("h")) {
                EVVValidator.showHelp(options);
                System.exit(0);
            }
            inputCA = line.getOptionValue("ca");
            inputCRL = line.getOptionValue("crl");
            inputFile = line.getOptionValue("file");
            if (line.hasOption("move")) {
                move = true;
            }
            if (line.hasOption("debug")) {
                showDebugInfos = true;
            }
            if (line.hasOption("date")) {
                inputDate = line.getOptionValue("date");
            }
            if (line.hasOption("input-dir")) {
                inputDir = line.getOptionValue("input-dir");
            }
            if (line.hasOption("output-dir")) {
                outputDir = line.getOptionValue("output-dir");
            }
        }
        catch (ParseException exp) {
            System.err.println("<< Parsing failed.  Reason: " + exp.getMessage() + " >>");
            EVVValidator.showHelp(options);
            System.out.println("");
            System.exit(1);
        }
        if (null != inputDir) {
            evvValidator.validateFromDir(inputDir, inputCA, inputCRL, inputDate, outputDir, move, showDebugInfos);
        } else {
            evvValidator.validateFromFile(inputFile, inputCA, inputCRL, inputDate, outputDir, showDebugInfos);
        }
    }

    public void validateFromDir(String inputDir, String inputCA, String inputCRL, String inputDate, String outputDir, boolean move, boolean showDebugInfos) {
        File file = new File(inputDir);
        File error = new File(file, "error");
        File ok = new File(file, "ok");
        if (move) {
            ok.mkdir();
            error.mkdir();
        }
        for (File current : file.listFiles()) {
            if (!current.getName().toLowerCase().endsWith(SUFIX_XML)) continue;
            ValidationResult result = this.validateFromFile(current.getAbsolutePath(), inputCA, inputCRL, inputDate, outputDir, showDebugInfos);
            if (!move) continue;
            this.move(error, ok, current, result);
        }
    }

    private void move(File error, File ok, File current, ValidationResult result) {
        if (result.isValid()) {
            current.renameTo(new File(ok, current.getName()));
        } else {
            current.renameTo(new File(error, current.getName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValidationResult validateFromFile(String inputFile, String inputCA, String inputCRL, String inputDate, String outputDir, boolean showDebugInfos) {
        ValidationResultImpl result = new ValidationResultImpl();
        SystemContext context = this.createSystemContext(outputDir, inputFile);
        OutputterStrategy out = context.getOutputterStrategy();
        try {
            out.write("### --- START --- ####");
            if (showDebugInfos) {
                this.printDebugInfo(out);
            }
            out.write("input eVV file: " + inputFile);
            out.write("input CRL file: " + inputCRL);
            out.write("input CA file: " + inputCA);
            out.write("input check date: " + inputDate);
            out.write("output dir: " + outputDir);
            Document xmldoc = XMLUtil.read(inputFile);
            Node timestamp = XMLUtil.extractTimeStamp(xmldoc);
            if (timestamp == null) {
                throw new CertificateException("Timestamp not found: this is not a valid eVV");
            }
            out.write("timestamp: " + timestamp.getTextContent());
            Date checkDate = this.getCheckDate(inputDate, timestamp);
            Node evvInfo = XMLUtil.extractDocumentInformation(xmldoc);
            if (evvInfo != null) {
                out.write(evvInfo.getChildNodes());
            } else {
                out.write("documentInformation: NO CONTENT");
            }
            out.write(XMLUtil.extractTraderDeclarationNumber(xmldoc));
            out.write(XMLUtil.extractTraderReference(xmldoc));
            out.write(XMLUtil.extractDeclaratTIN(xmldoc));
            Node x509token = XMLUtil.extractX509Token(xmldoc);
            if (x509token == null) {
                throw new CertificateException("X509 Certificate not found: this is not a valid eVV");
            }
            X509CertificateBuilder builder = new X509CertificateBuilder(context);
            X509Certificate x509 = builder.createCertificate(x509token.getTextContent());
            out.write("certificate", x509);
            X509Certificate ca = builder.createCertificateFromPath(inputCA);
            out.write("CA", ca);
            X509CertificateValidator x509validator = new X509CertificateValidator(context, ca);
            x509validator.setDate(checkDate);
            if (inputCRL != null && inputCRL.length() != 0) {
                X509CRLBuilder crlBuilder = new X509CRLBuilder(context);
                X509CRL crl = crlBuilder.createCRLFromPath(inputCRL);
                out.write("CRL", crl);
                x509validator.setX509crl(crl);
            } else {
                out.write("CRL: NOT SET");
            }
            out.write("check certificate date: " + checkDate);
            boolean certValid = x509validator.isValid(x509);
            String statusCert = certValid ? "OK" : "NOT OK";
            out.write("check certificate: " + statusCert);
            Node dsSignature = XMLUtil.extractDSignature(xmldoc);
            XMLSignatureValidator sigValidator = new XMLSignatureValidator(context, x509.getPublicKey());
            boolean sigValid = sigValidator.isValid(dsSignature);
            String statusSign = sigValid ? "OK" : "NOT OK";
            out.write("check signature: " + statusSign);
            if (certValid && sigValid) {
                result.setValid(true);
            } else {
                result.setValid(false);
                result.setMessage("certificate: " + statusCert + ", signature: " + statusSign);
            }
        }
        catch (Throwable e) {
            out.write("ERROR", e);
            result.setValid(false);
            result.setException(e);
            result.setMessage(e.getMessage());
        }
        finally {
            out.write("### --- END --- ###");
            out.close();
        }
        return result;
    }

    private void printDebugInfo(OutputterStrategy out) {
        if (showSystemInfo) {
            out.write("system jre version: " + System.getProperty("java.version"));
            out.write("system jre vendor: " + System.getProperty("java.vendor"));
            out.write("system jre home: " + System.getProperty("java.home"));
            out.write("system os: " + System.getProperty("os.name"));
            out.write("system os version: " + System.getProperty("os.version"));
            out.write("system java endorsed dirs: " + System.getProperty("java.endorsed.dirs"));
            out.write("system java user dir: " + System.getProperty("user.dir"));
            out.write("system user home: " + System.getProperty("user.home"));
        }
    }

    public void addOutputterStrategy(OutputterStrategy strategy) {
        this.outputterStrategies.add(strategy);
    }

    private Date getCheckDate(String inputDate, Node timestamp) throws java.text.ParseException {
        if (inputDate == null) {
            return this.getDateFromTimestampNode(timestamp);
        }
        return this.getDateFromString(inputDate);
    }

    private Date getDateFromString(String str) throws java.text.ParseException {
        if (str == null) {
            return new Date();
        }
        SimpleDateFormat sdf = null;
        sdf = str.matches(".*-.*") ? new SimpleDateFormat("yyyy.MM.dd-HH:mm:ss") : new SimpleDateFormat("yyyy.MM.dd");
        return sdf.parse(str);
    }

    private Date getDateFromTimestampNode(Node timestamp) throws java.text.ParseException {
        if (timestamp == null) {
            return new Date();
        }
        Date date = null;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.S'Z'");
            date = sdf.parse(timestamp.getTextContent());
        }
        catch (java.text.ParseException pex) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            date = sdf.parse(timestamp.getTextContent());
        }
        return date;
    }

    private SystemContext createSystemContext(String outDir, String inputFile) {
        SystemContextImpl context = new SystemContextImpl();
        MultipleOutputter outputter = new MultipleOutputter();
        outputter.addOutputter(new ConsoleOutputter());
        for (OutputterStrategy outputterStrategy : this.outputterStrategies) {
            outputter.addOutputter(outputterStrategy);
        }
        context.setOutputterStrategy(outputter);
        if (outDir != null) {
            File logDir = new File(outDir);
            if (!logDir.exists()) {
                logDir.mkdir();
            }
            File file = new File(inputFile);
            String name = file.getName();
            File outFile = new File(outDir + File.separator + name + ".txt");
            try {
                FileOutputter fileOutputter = new FileOutputter(outFile);
                outputter.addOutputter(fileOutputter);
            }
            catch (FileNotFoundException e) {
                outputter.write("Output dir not found", e);
            }
        }
        ProviderSelectorImpl selector = new ProviderSelectorImpl();
        context.setProviderSelector(selector);
        return context;
    }

    private static void showHelp(Options options) {
        System.out.println("e-dec eVV Validator");
        System.out.println("===================");
        System.out.println("");
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("EVVValidator", options);
    }

    private Options getCommandLineOptions() {
        Option optionHelp = new Option("h", "help", false, "print this message");
        Option optionMove = new Option("m", "move", false, "Move");
        Option optionDebug = new Option("d", "debug", false, "Show debug infos");
        Option optionCA = Option.builder().longOpt("ca").required(true).hasArg(true).argName("FILENAME").build();
        Option optionCRL = Option.builder().longOpt("crl").required(true).hasArg(true).argName("FILENAME").build();
        Option optionFile = Option.builder().longOpt("file").required(true).hasArg(true).argName("FILENAME").build();
        Option optionDate = Option.builder().longOpt("date").required(false).hasArg(true).argName("DATE").build();
        Option optionDir = Option.builder().longOpt("input-dir").required(false).hasArg(true).argName("DIR").build();
        Option optionOut = Option.builder().longOpt("output-dir").required(false).hasArg(true).argName("DIR").build();
        Options options = new Options();
        options.addOption(optionCA);
        options.addOption(optionCRL);
        options.addOption(optionDate);
        options.addOption(optionDir);
        options.addOption(optionFile);
        options.addOption(optionHelp);
        options.addOption(optionMove);
        options.addOption(optionOut);
        options.addOption(optionDebug);
        return options;
    }
}

