/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.edec.dsig.builder;

import ch.admin.bit.edec.dsig.context.SystemContext;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;

public class X509CertificateBuilder {
    private static final String HEADER = "-----BEGIN CERTIFICATE-----\n";
    private static final String FOOTER = "\n-----END CERTIFICATE-----";
    private final SystemContext context;

    public X509CertificateBuilder(SystemContext context) {
        this.context = context;
    }

    public X509Certificate createCertificate(String content) throws CertificateException, NoSuchProviderException {
        byte[] x509data = (HEADER + content + FOOTER).getBytes();
        ByteArrayInputStream bis = new ByteArrayInputStream(x509data);
        CertificateFactory cf = this.context.getProviderSelector().getCertificateFactory();
        return (X509Certificate)cf.generateCertificate(bis);
    }

    public X509Certificate createCertificateFromPath(String path) throws CertificateException, FileNotFoundException, NoSuchProviderException {
        File file = new File(path);
        FileInputStream is = new FileInputStream(file);
        CertificateFactory cf = this.context.getProviderSelector().getCertificateFactory();
        X509Certificate cert = (X509Certificate)cf.generateCertificate(is);
        try {
            ((InputStream)is).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return cert;
    }
}

