/*
 * Project: e-Dec Example Code
 * (C) 2017 Bundesamt fuer Informatik und Telekommunikation, CH
 */
package ch.admin.bit.edec.examples.ws;

import javax.net.ssl.KeyManager;
import javax.net.ssl.TrustManager;

/**
 * This class is an extension to ConnectionParams. It holds additional parameters that are used only
 * in combination with SSL.
 */
public class SslConnectionParams extends ConnectionParams {
  private String keystorePath;
  private String keystorePassword;
  private String truststorePath;
  private String truststorePassword;
  private String identityPassword;

  public SslConnectionParams() {
  }

  public SslConnectionParams(ConnectionParams params) {
    setProtocol(params.getProtocol());
    setPath(params.getPath());
    setHost(params.getHost());
    setSoapAction(params.getSoapAction());
    setRequestMethod(params.getRequestMethod());
    setSslHeaderAddition(params.getSslHeaderAddition());
    setPort(params.getPort());
    setUrl(params.getUrl());
    setRequest(params.getRequest());
  }

  public String getKeystorePath() {
    return keystorePath;
  }

  public void setKeystorePath(String keystorePath) {
    this.keystorePath = keystorePath;
  }

  public String getKeystorePassword() {
    return keystorePassword;
  }

  public void setKeystorePassword(String keystorePassword) {
    this.keystorePassword = keystorePassword;
  }

  public String getTruststorePath() {
    return truststorePath;
  }

  public void setTruststorePath(String truststorePath) {
    this.truststorePath = truststorePath;
  }

  public String getTruststorePassword() {
    return truststorePassword;
  }

  public void setTruststorePassword(String truststorePassword) {
    this.truststorePassword = truststorePassword;
  }

  public String getIdentityPassword() {
    return identityPassword;
  }

  public void setIdentityPassword(String identityPassword) {
    this.identityPassword = identityPassword;
  }
}
