/*
 * Project: e-Dec Example Code
 * (C) 2017 Bundesamt fuer Informatik und Telekommunikation, CH
 */
package ch.admin.bit.edec.examples;

import ch.admin.bit.edec.examples.fileHandling.FileHandler;
import ch.admin.bit.edec.examples.fileHandling.FileHandlerException;
import ch.admin.bit.edec.examples.ws.ConnectionParams;
import ch.admin.bit.edec.examples.ws.HttpsRequest;
import ch.admin.bit.edec.examples.ws.SOAPRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * This class determines the type of request that has to be sent to the webservice.
 */
public class RequestSender {
  private static final Log log = LogFactory.getLog(HttpsRequest.class);

  public static String sendRequest(String fileName) {
    EdecRequestResponse request = null;
    EdecRequestResponse response = null;
    try {
      request = FileHandler.loadXmlFile(fileName);
    }
    catch (FileHandlerException e1) {
      e1.printStackTrace();
    }

    if (null == request) {
      return null;
    }

    ConnectionParams params = createConnectionParams();
    params.setRequest(request.getContent());

    EdecRequestType type = request.getType();
    if (type.isEdec()) {
      response = sendEdecRequest(params);
    }
    else if (type.isBordereau()) {
      response = sendBordereauRequest(params);
    }
    else if (type.isReceipt()) {
      response = sendReceiptRequest(params);
    }
    else {
      return null;
    }

    return response.getContent();
  }

  private static EdecRequestResponse sendEdecRequest(ConnectionParams params) {
    SOAPRequest soapRequest = new SOAPRequest();
    params.setPath(PropertyProvider.getProperty(PropertyProvider.PROP_WS_PATH_EDEC));
    String xmlResponse = soapRequest.sendRequest(params);
    EdecRequestResponse response = new EdecRequestResponse(xmlResponse, EdecRequestType.TYPE_EDEC);
    return response;
  }

  private static EdecRequestResponse sendBordereauRequest(ConnectionParams params) {
    SOAPRequest soapRequest = new SOAPRequest();
    params.setPath(PropertyProvider.getProperty(PropertyProvider.PROP_WS_PATH_BORDEREAU));
    String xmlResponse = soapRequest.sendRequest(params);
    EdecRequestResponse response = new EdecRequestResponse(xmlResponse, EdecRequestType.TYPE_RECEIPT);
    return response;
  }

  private static EdecRequestResponse sendReceiptRequest(ConnectionParams params) {
    SOAPRequest soapRequest = new SOAPRequest();
    params.setPath(PropertyProvider.getProperty(PropertyProvider.PROP_WS_PATH_RECEIPT));
    String xmlResponse = soapRequest.sendRequest(params);
    EdecRequestResponse response = new EdecRequestResponse(xmlResponse, EdecRequestType.TYPE_RECEIPT);
    return response;
  }

  /**
   * Creates the connection parameter object from the properties.
   * @return Connection parameters.
   */
  private static ConnectionParams createConnectionParams() {
    ConnectionParams params = new ConnectionParams();
    params.setSslHeaderAddition(PropertyProvider.getProperty(PropertyProvider.PROP_WS_SSL_HEADER_ADDITION));
    params.setHost(PropertyProvider.getProperty(PropertyProvider.PROP_WS_HOST));
    params.setPort(Integer.valueOf(PropertyProvider.getProperty(PropertyProvider.PROP_WS_PORT)));
    params.setRequestMethod("POST");
    params.setSoapAction(PropertyProvider.getProperty(PropertyProvider.PROP_WS_SOAP_ACTION));
    params.setProtocol(PropertyProvider.getProperty(PropertyProvider.PROP_WS_PROTOCOL));

    return params;
  }
}