/*
 * Project: e-Dec Example Code
 * (C) 2017 Bundesamt fuer Informatik und Telekommunikation, CH
 */
package ch.admin.bit.edec.examples;

/**
 * This enum represents the service type that is used for a request. Each typ has a XML-node name that corresponds
 * tho the respective schema name.
 */
public enum EdecRequestType {
  TYPE_EDEC("goodsDeclarations"), TYPE_RECEIPT("receiptRequest"), TYPE_BORDEREAU("bordereauRequest");

  private String name;

  private EdecRequestType(String name) {
    this.name = name;
  }

  public String getName() {
    return name;
  }

  public boolean isEdec() {
    return this.equals(TYPE_EDEC);
  }

  public boolean isReceipt() {
    return this.equals(TYPE_RECEIPT);
  }

  public boolean isBordereau() {
    return this.equals(TYPE_BORDEREAU);
  }
}
