/*
 * Project: e-Dec Example Code
 * (C) 2017 Bundesamt fuer Informatik und Telekommunikation, CH
 */
package ch.admin.bit.edec.examples;

/**
 * This class represents a request and a response. It holds the respective texts and the type of service that it
 * belongs to (EDEC, RECEIPT, BORDEREAU)
 */
public class EdecRequestResponse {
  private String content;
  private EdecRequestType type;

  // No standard constructor
  private EdecRequestResponse() {
  }

  public EdecRequestResponse(String content, EdecRequestType type) {
    this.content = content;
    this.type = type;
  }

  public String getContent() {
    return content;
  }

  public void setContent(String content) {
    this.content = content;
  }

  public EdecRequestType getType() {
    return type;
  }

  public void setType(EdecRequestType type) {
    this.type = type;
  }
}
