/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.security.GeneralSecurityException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.tls.crypto.impl.TlsBlockCipherImpl;

public class JceBlockCipherImpl
implements TlsBlockCipherImpl {
    private final int cipherMode;
    private final Cipher cipher;
    private final String algorithm;
    private SecretKey key;

    public JceBlockCipherImpl(Cipher cipher, String string, boolean bl) throws GeneralSecurityException {
        this.cipher = cipher;
        this.algorithm = string;
        this.cipherMode = bl ? 1 : 2;
    }

    public void setKey(byte[] byArray, int n, int n2) {
        this.key = new SecretKeySpec(byArray, n, n2, this.algorithm);
    }

    public void init(byte[] byArray, int n, int n2) {
        try {
            this.cipher.init(this.cipherMode, (Key)this.key, new IvParameterSpec(byArray, n, n2));
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new IllegalStateException(generalSecurityException);
        }
    }

    public int doFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        try {
            return this.cipher.doFinal(byArray, n, n2, byArray2, n3);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new IllegalStateException(generalSecurityException);
        }
    }

    public int getBlockSize() {
        return this.cipher.getBlockSize();
    }
}

