/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.bc;

import java.io.IOException;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.DSA;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.signers.DSADigestSigner;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsSigner;

public abstract class BcTlsDSSSigner
extends BcTlsSigner {
    protected BcTlsDSSSigner(BcTlsCrypto bcTlsCrypto, AsymmetricKeyParameter asymmetricKeyParameter) {
        super(bcTlsCrypto, asymmetricKeyParameter);
    }

    protected abstract DSA createDSAImpl(short var1);

    protected abstract short getSignatureAlgorithm();

    public byte[] generateRawSignature(SignatureAndHashAlgorithm signatureAndHashAlgorithm, byte[] byArray) throws IOException {
        if (signatureAndHashAlgorithm != null && signatureAndHashAlgorithm.getSignature() != this.getSignatureAlgorithm()) {
            throw new IllegalStateException();
        }
        short s = signatureAndHashAlgorithm == null ? (short)2 : (short)signatureAndHashAlgorithm.getHash();
        DSADigestSigner dSADigestSigner = new DSADigestSigner(this.createDSAImpl(s), this.crypto.createDigest((short)0));
        dSADigestSigner.init(true, new ParametersWithRandom(this.privateKey, this.crypto.getSecureRandom()));
        DSADigestSigner dSADigestSigner2 = dSADigestSigner;
        if (signatureAndHashAlgorithm == null) {
            dSADigestSigner2.update(byArray, 16, 20);
        } else {
            dSADigestSigner2.update(byArray, 0, byArray.length);
        }
        try {
            return dSADigestSigner2.generateSignature();
        }
        catch (CryptoException cryptoException) {
            throw new TlsFatalAlert(80, (Throwable)cryptoException);
        }
    }
}

