/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.DigestInputBuffer;
import org.bouncycastle.tls.DigitallySigned;
import org.bouncycastle.tls.TlsCredentialedSigner;
import org.bouncycastle.tls.TlsCredentials;
import org.bouncycastle.tls.TlsDHConfigVerifier;
import org.bouncycastle.tls.TlsDHKeyExchange;
import org.bouncycastle.tls.TlsDHUtils;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsDHConfig;
import org.bouncycastle.tls.crypto.TlsVerifier;
import org.bouncycastle.util.io.TeeInputStream;

public class TlsDHEKeyExchange
extends TlsDHKeyExchange {
    protected TlsCredentialedSigner serverCredentials = null;
    protected TlsVerifier verifier = null;

    private static int checkKeyExchange(int n) {
        switch (n) {
            case 3: 
            case 5: {
                return n;
            }
        }
        throw new IllegalArgumentException("unsupported key exchange algorithm");
    }

    public TlsDHEKeyExchange(int n, Vector vector, TlsDHConfigVerifier tlsDHConfigVerifier) {
        super(TlsDHEKeyExchange.checkKeyExchange(n), vector, tlsDHConfigVerifier);
    }

    public TlsDHEKeyExchange(int n, Vector vector, TlsDHConfig tlsDHConfig) {
        super(TlsDHEKeyExchange.checkKeyExchange(n), vector, tlsDHConfig);
    }

    public void processServerCredentials(TlsCredentials tlsCredentials) throws IOException {
        if (!(tlsCredentials instanceof TlsCredentialedSigner)) {
            throw new TlsFatalAlert(80);
        }
        this.serverCredentials = (TlsCredentialedSigner)tlsCredentials;
    }

    public void processServerCertificate(Certificate certificate) throws IOException {
        if (certificate.isEmpty()) {
            throw new TlsFatalAlert(42);
        }
        this.checkServerCertSigAlg(certificate);
        this.verifier = certificate.getCertificateAt(0).createVerifier(TlsUtils.getSignatureAlgorithm(this.keyExchange));
    }

    public byte[] generateServerKeyExchange() throws IOException {
        if (this.dhConfig == null) {
            throw new TlsFatalAlert(80);
        }
        DigestInputBuffer digestInputBuffer = new DigestInputBuffer();
        TlsDHUtils.writeDHConfig(this.dhConfig, digestInputBuffer);
        this.agreement = this.context.getCrypto().createDHDomain(this.dhConfig).createDH();
        this.generateEphemeral(digestInputBuffer);
        DigitallySigned digitallySigned = TlsUtils.generateServerKeyExchangeSignature(this.context, this.serverCredentials, digestInputBuffer);
        digitallySigned.encode(digestInputBuffer);
        return digestInputBuffer.toByteArray();
    }

    public void processServerKeyExchange(InputStream inputStream) throws IOException {
        DigestInputBuffer digestInputBuffer = new DigestInputBuffer();
        TeeInputStream teeInputStream = new TeeInputStream(inputStream, digestInputBuffer);
        this.dhConfig = TlsDHUtils.receiveDHConfig(this.dhConfigVerifier, teeInputStream);
        byte[] byArray = TlsUtils.readOpaque16(teeInputStream);
        DigitallySigned digitallySigned = this.parseSignature(inputStream);
        TlsUtils.verifyServerKeyExchangeSignature(this.context, this.verifier, digestInputBuffer, digitallySigned);
        this.agreement = this.context.getCrypto().createDHDomain(this.dhConfig).createDH();
        this.processEphemeral(byArray);
    }

    public short[] getClientCertificateTypes() {
        return new short[]{2, 64, 1};
    }

    public void processClientCredentials(TlsCredentials tlsCredentials) throws IOException {
        if (!(tlsCredentials instanceof TlsCredentialedSigner)) {
            throw new TlsFatalAlert(80);
        }
    }
}

