/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.SecurityParameters;
import org.bouncycastle.tls.TlsContext;
import org.bouncycastle.tls.TlsSession;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCrypto;
import org.bouncycastle.tls.crypto.TlsNonceGenerator;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Pack;
import org.bouncycastle.util.Times;

abstract class AbstractTlsContext
implements TlsContext {
    private static long counter = Times.nanoTime();
    private TlsCrypto crypto;
    private TlsNonceGenerator nonceGenerator;
    private SecurityParameters securityParameters;
    private ProtocolVersion clientVersion = null;
    private ProtocolVersion serverVersion = null;
    private TlsSession session = null;
    private Object userObject = null;

    private static synchronized long nextCounterValue() {
        return ++counter;
    }

    private static TlsNonceGenerator createNonceGenerator(TlsCrypto tlsCrypto, SecurityParameters securityParameters) {
        byte[] byArray = new byte[16];
        Pack.longToBigEndian(AbstractTlsContext.nextCounterValue(), byArray, 0);
        Pack.longToBigEndian(Times.nanoTime(), byArray, 8);
        byArray[0] = (byte)securityParameters.entity;
        return tlsCrypto.createNonceGenerator(byArray);
    }

    AbstractTlsContext(TlsCrypto tlsCrypto, SecurityParameters securityParameters) {
        this.crypto = tlsCrypto;
        this.nonceGenerator = AbstractTlsContext.createNonceGenerator(tlsCrypto, securityParameters);
        this.securityParameters = securityParameters;
    }

    public TlsCrypto getCrypto() {
        return this.crypto;
    }

    public TlsNonceGenerator getNonceGenerator() {
        return this.nonceGenerator;
    }

    public SecurityParameters getSecurityParameters() {
        return this.securityParameters;
    }

    public ProtocolVersion getClientVersion() {
        return this.clientVersion;
    }

    void setClientVersion(ProtocolVersion protocolVersion) {
        this.clientVersion = protocolVersion;
    }

    public ProtocolVersion getServerVersion() {
        return this.serverVersion;
    }

    void setServerVersion(ProtocolVersion protocolVersion) {
        this.serverVersion = protocolVersion;
    }

    public TlsSession getResumableSession() {
        TlsSession tlsSession = this.getSession();
        if (tlsSession == null || !tlsSession.isResumable()) {
            return null;
        }
        return tlsSession;
    }

    public TlsSession getSession() {
        return this.session;
    }

    void setSession(TlsSession tlsSession) {
        this.session = tlsSession;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public void setUserObject(Object object) {
        this.userObject = object;
    }

    public byte[] exportChannelBinding(int n) {
        switch (n) {
            case 1: {
                byte[] byArray = this.getSecurityParameters().getTLSUnique();
                if (byArray == null) {
                    throw new IllegalStateException("'tls-unique' channel binding unavailable before handshake completion");
                }
                return Arrays.clone(byArray);
            }
        }
        throw new UnsupportedOperationException();
    }

    public byte[] exportKeyingMaterial(String string, byte[] byArray, int n) {
        if (byArray != null && !TlsUtils.isValidUint16(byArray.length)) {
            throw new IllegalArgumentException("'context_value' must have length less than 2^16 (or be null)");
        }
        SecurityParameters securityParameters = this.getSecurityParameters();
        byte[] byArray2 = securityParameters.getClientRandom();
        byte[] byArray3 = securityParameters.getServerRandom();
        int n2 = byArray2.length + byArray3.length;
        if (byArray != null) {
            n2 += 2 + byArray.length;
        }
        byte[] byArray4 = new byte[n2];
        int n3 = 0;
        System.arraycopy(byArray2, 0, byArray4, n3, byArray2.length);
        System.arraycopy(byArray3, 0, byArray4, n3 += byArray2.length, byArray3.length);
        n3 += byArray3.length;
        if (byArray != null) {
            TlsUtils.writeUint16(byArray.length, byArray4, n3);
            System.arraycopy(byArray, 0, byArray4, n3 += 2, byArray.length);
            n3 += byArray.length;
        }
        if (n3 != n2) {
            throw new IllegalStateException("error in calculation of seed for export");
        }
        return TlsUtils.PRF(this, securityParameters.getMasterSecret(), string, byArray4, n).extract();
    }
}

