/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.util.Locale;
import java.util.Vector;
import java.util.logging.Logger;
import org.bouncycastle.jsse.provider.FipsUtils;
import org.bouncycastle.jsse.provider.JsseUtils;
import org.bouncycastle.jsse.provider.PropertyUtils;
import org.bouncycastle.tls.NamedGroup;
import org.bouncycastle.tls.TlsDHUtils;
import org.bouncycastle.tls.crypto.DHStandardGroups;
import org.bouncycastle.tls.crypto.TlsDHConfig;
import org.bouncycastle.util.Arrays;

abstract class SupportedGroups {
    private static Logger LOG = Logger.getLogger(SupportedGroups.class.getName());
    private static final String PROPERTY_NAME = "jdk.tls.namedGroups";
    private static final boolean provDisableChar2 = PropertyUtils.getBooleanSystemProperty("org.bouncycastle.jsse.ec.disableChar2", false);
    private static final int[] provJdkTlsNamedGroups = SupportedGroups.getJdkTlsNamedGroups(provDisableChar2);
    private static final int[] defaultClientNamedGroups = new int[]{23, 24, 25, 256, 257, 258};

    SupportedGroups() {
    }

    private static int getDefaultCurve(int n) {
        return n <= 256 ? 23 : (n <= 384 ? 24 : (n <= 521 ? 25 : (!provDisableChar2 && n <= 571 ? 14 : -1)));
    }

    private static TlsDHConfig getDefaultDHConfig(int n) {
        return n <= 1024 ? new TlsDHConfig(DHStandardGroups.rfc2409_1024) : (n <= 1536 ? new TlsDHConfig(DHStandardGroups.rfc3526_1536) : TlsDHUtils.createNamedDHConfig(SupportedGroups.getDefaultFiniteField(n)));
    }

    private static int getDefaultFiniteField(int n) {
        return n <= 2048 ? 256 : (n <= 3072 ? 257 : (n <= 4096 ? 258 : (n <= 6144 ? 259 : (n <= 8192 ? 260 : -1))));
    }

    private static int[] getJdkTlsNamedGroups(boolean bl) {
        String string = PropertyUtils.getStringSystemProperty(PROPERTY_NAME);
        if (string == null) {
            return null;
        }
        String[] stringArray = JsseUtils.stripQuotes(string.trim()).toLowerCase(Locale.ENGLISH).split(",");
        int[] nArray = new int[stringArray.length];
        int n = 0;
        for (String string2 : stringArray) {
            String string3 = string2.trim();
            if (string3.length() < 1) continue;
            int n2 = NamedGroup.getByName(string3.trim());
            if (n2 < 0) {
                LOG.warning("'jdk.tls.namedGroups' contains unrecognised NamedGroup: " + string3);
                continue;
            }
            if (bl && NamedGroup.isChar2Curve(n2)) {
                LOG.warning("'jdk.tls.namedGroups' contains disabled characteristic-2 curve: " + string3);
                continue;
            }
            nArray[n++] = n2;
        }
        if (n < nArray.length) {
            nArray = Arrays.copyOf(nArray, n);
        }
        if (nArray.length < 1) {
            LOG.severe("'jdk.tls.namedGroups' contained no usable NamedGroup values");
        }
        return nArray;
    }

    static Vector getClientSupportedGroups(boolean bl, boolean bl2, boolean bl3) {
        int[] nArray = provJdkTlsNamedGroups != null ? provJdkTlsNamedGroups : defaultClientNamedGroups;
        Vector<Integer> vector = new Vector<Integer>();
        for (int n : nArray) {
            if ((!bl2 || !NamedGroup.refersToASpecificFiniteField(n)) && (!bl3 || !NamedGroup.refersToASpecificCurve(n)) || bl && !FipsUtils.isFipsNamedGroup(n)) continue;
            vector.addElement(n);
        }
        return vector;
    }

    static int getServerDefaultCurve(boolean bl, int n) {
        int[] nArray = provJdkTlsNamedGroups;
        if (nArray == null) {
            if (bl) {
                return FipsUtils.getFipsDefaultCurve(n);
            }
            return SupportedGroups.getDefaultCurve(n);
        }
        for (int n2 : nArray) {
            if (NamedGroup.getCurveBits(n2) < n || bl && !FipsUtils.isFipsNamedGroup(n2)) continue;
            return n2;
        }
        return -1;
    }

    static TlsDHConfig getServerDefaultDHConfig(boolean bl, int n) {
        int[] nArray = provJdkTlsNamedGroups;
        if (nArray == null) {
            if (bl) {
                return TlsDHUtils.createNamedDHConfig(FipsUtils.getFipsDefaultFiniteField(n));
            }
            return SupportedGroups.getDefaultDHConfig(n);
        }
        for (int n2 : nArray) {
            if (NamedGroup.getFiniteFieldBits(n2) < n || bl && !FipsUtils.isFipsNamedGroup(n2)) continue;
            return new TlsDHConfig(n2);
        }
        return null;
    }

    static int getServerMaximumNegotiableCurveBits(boolean bl, int[] nArray) {
        int[] nArray2 = provJdkTlsNamedGroups;
        if (nArray == null) {
            if (nArray2 == null) {
                return bl ? FipsUtils.getFipsMaximumCurveBits() : (provDisableChar2 ? NamedGroup.getMaximumPrimeCurveBits() : NamedGroup.getMaximumCurveBits());
            }
            int n = 0;
            for (int i = 0; i < nArray2.length; ++i) {
                int n2 = nArray2[i];
                if (bl && !FipsUtils.isFipsNamedGroup(n2)) continue;
                n = Math.max(n, NamedGroup.getCurveBits(n2));
            }
            return n;
        }
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            int n3 = nArray[i];
            if (provDisableChar2 && NamedGroup.isChar2Curve(n3) || nArray2 != null && !Arrays.contains(nArray2, n3) || bl && !FipsUtils.isFipsNamedGroup(n3)) continue;
            n = Math.max(n, NamedGroup.getCurveBits(n3));
        }
        return n;
    }

    static int getServerMaximumNegotiableFiniteFieldBits(boolean bl, int[] nArray) {
        int[] nArray2 = provJdkTlsNamedGroups;
        if (nArray == null) {
            if (nArray2 == null) {
                return bl ? FipsUtils.getFipsMaximumFiniteFieldBits() : NamedGroup.getMaximumFiniteFieldBits();
            }
            int n = 0;
            for (int i = 0; i < nArray2.length; ++i) {
                int n2 = nArray2[i];
                if (bl && !FipsUtils.isFipsNamedGroup(n2)) continue;
                n = Math.max(n, NamedGroup.getFiniteFieldBits(n2));
            }
            return n;
        }
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            int n3 = nArray[i];
            if (nArray2 != null && !Arrays.contains(nArray2, n3) || bl && !FipsUtils.isFipsNamedGroup(n3)) continue;
            n = Math.max(n, NamedGroup.getFiniteFieldBits(n3));
        }
        return n;
    }

    static int getServerSelectedCurve(boolean bl, int n, int[] nArray) {
        int[] nArray2 = provJdkTlsNamedGroups;
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = nArray[i];
            if (provDisableChar2 && NamedGroup.isChar2Curve(n2) || nArray2 != null && !Arrays.contains(nArray2, n2) || NamedGroup.getCurveBits(n2) < n || bl && !FipsUtils.isFipsNamedGroup(n2)) continue;
            return n2;
        }
        return -1;
    }

    static int getServerSelectedFiniteField(boolean bl, int n, int[] nArray) {
        int[] nArray2 = provJdkTlsNamedGroups;
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = nArray[i];
            if (nArray2 != null && !Arrays.contains(nArray2, n2) || NamedGroup.getFiniteFieldBits(n2) < n || bl && !FipsUtils.isFipsNamedGroup(n2)) continue;
            return n2;
        }
        return -1;
    }
}

