/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.X509KeyManager;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.jsse.BCSNIServerName;
import org.bouncycastle.jsse.provider.JsseUtils;
import org.bouncycastle.jsse.provider.PropertyUtils;
import org.bouncycastle.jsse.provider.ProvDHConfigVerifier;
import org.bouncycastle.jsse.provider.ProvSSLConnection;
import org.bouncycastle.jsse.provider.ProvSSLParameters;
import org.bouncycastle.jsse.provider.ProvSSLSessionContext;
import org.bouncycastle.jsse.provider.ProvSSLSessionImpl;
import org.bouncycastle.jsse.provider.ProvTlsManager;
import org.bouncycastle.jsse.provider.ProvTlsPeer;
import org.bouncycastle.jsse.provider.SupportedGroups;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.CertificateRequest;
import org.bouncycastle.tls.CertificateStatusRequest;
import org.bouncycastle.tls.DefaultTlsClient;
import org.bouncycastle.tls.DefaultTlsKeyExchangeFactory;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.ServerName;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.TlsAuthentication;
import org.bouncycastle.tls.TlsCredentials;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsServerCertificate;
import org.bouncycastle.tls.TlsSession;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCrypto;
import org.bouncycastle.tls.crypto.TlsCryptoParameters;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaDefaultTlsCredentialedSigner;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;
import org.bouncycastle.tls.crypto.impl.jcajce.JceDefaultTlsCredentialedAgreement;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.IPAddress;
import org.bouncycastle.util.encoders.Hex;

class ProvTlsClient
extends DefaultTlsClient
implements ProvTlsPeer {
    private static Logger LOG = Logger.getLogger(ProvTlsClient.class.getName());
    private static final boolean provEnableSNIExtension = PropertyUtils.getBooleanSystemProperty("jsse.enableSNIExtension", true);
    protected final ProvTlsManager manager;
    protected final ProvSSLParameters sslParameters;
    protected ProvSSLSessionImpl sslSession = null;
    protected boolean handshakeComplete = false;

    ProvTlsClient(ProvTlsManager provTlsManager) {
        super(provTlsManager.getContextData().getCrypto(), new DefaultTlsKeyExchangeFactory(), new ProvDHConfigVerifier());
        this.manager = provTlsManager;
        this.sslParameters = provTlsManager.getProvSSLParameters();
    }

    protected CertificateStatusRequest getCertificateStatusRequest() {
        return null;
    }

    protected Vector getSupportedGroups(boolean bl, boolean bl2) {
        return SupportedGroups.getClientSupportedGroups(this.manager.getContext().isFips(), bl, bl2);
    }

    protected Vector getSNIServerNames() {
        if (provEnableSNIExtension) {
            List<BCSNIServerName> list = this.manager.getProvSSLParameters().getServerNames();
            if (list == null) {
                String string = this.manager.getPeerHost();
                if (string != null && string.indexOf(46) > 0 && !IPAddress.isValid(string)) {
                    Vector<ServerName> vector = new Vector<ServerName>(1);
                    vector.addElement(new ServerName(0, string));
                    return vector;
                }
            } else {
                Vector<ServerName> vector = new Vector<ServerName>(list.size());
                for (BCSNIServerName bCSNIServerName : list) {
                    if (bCSNIServerName.getType() != 0) continue;
                    try {
                        vector.addElement(new ServerName((short)bCSNIServerName.getType(), new String(bCSNIServerName.getEncoded(), "ASCII")));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        LOG.log(Level.WARNING, "Unable to include SNI server name", unsupportedEncodingException);
                    }
                }
                if (!vector.isEmpty()) {
                    return vector;
                }
            }
        }
        return null;
    }

    protected Vector getSupportedSignatureAlgorithms() {
        return JsseUtils.getSupportedSignatureAlgorithms(this.getCrypto());
    }

    public synchronized boolean isHandshakeComplete() {
        return this.handshakeComplete;
    }

    public TlsAuthentication getAuthentication() throws IOException {
        return new TlsAuthentication(){

            public TlsCredentials getClientCredentials(CertificateRequest certificateRequest) throws IOException {
                Object object;
                X500Name[] x500NameArray;
                int n = TlsUtils.getKeyExchangeAlgorithm(ProvTlsClient.this.selectedCipherSuite);
                switch (n) {
                    case 7: 
                    case 9: 
                    case 16: 
                    case 18: {
                        return null;
                    }
                    case 1: 
                    case 3: 
                    case 5: 
                    case 17: 
                    case 19: {
                        break;
                    }
                    default: {
                        throw new TlsFatalAlert(80);
                    }
                }
                X509KeyManager x509KeyManager = ProvTlsClient.this.manager.getContextData().getKeyManager();
                if (x509KeyManager == null) {
                    return null;
                }
                short[] sArray = certificateRequest.getCertificateTypes();
                if (sArray == null || sArray.length == 0) {
                    return null;
                }
                String[] stringArray = new String[sArray.length];
                for (int i = 0; i < sArray.length; ++i) {
                    stringArray[i] = JsseUtils.getAuthTypeClient(sArray[i]);
                }
                Principal[] principalArray = null;
                Vector vector = certificateRequest.getCertificateAuthorities();
                if (vector != null && vector.size() > 0) {
                    x500NameArray = vector.toArray(new X500Name[vector.size()]);
                    object = JsseUtils.toX500Principals(x500NameArray);
                    principalArray = object.toArray(new Principal[object.size()]);
                }
                if ((object = x509KeyManager.chooseClientAlias(stringArray, principalArray, (Socket)(x500NameArray = null))) == null) {
                    return null;
                }
                TlsCrypto tlsCrypto = ProvTlsClient.this.getCrypto();
                if (!(tlsCrypto instanceof JcaTlsCrypto)) {
                    throw new UnsupportedOperationException();
                }
                PrivateKey privateKey = x509KeyManager.getPrivateKey((String)object);
                Certificate certificate = JsseUtils.getCertificateMessage(tlsCrypto, x509KeyManager.getCertificateChain((String)object));
                if (privateKey == null || certificate.isEmpty()) {
                    return null;
                }
                switch (n) {
                    case 7: 
                    case 9: 
                    case 16: 
                    case 18: {
                        return new JceDefaultTlsCredentialedAgreement((JcaTlsCrypto)tlsCrypto, certificate, privateKey);
                    }
                    case 1: 
                    case 3: 
                    case 5: 
                    case 17: 
                    case 19: {
                        short s = certificate.getCertificateAt(0).getClientCertificateType();
                        short s2 = TlsUtils.getSignatureAlgorithmClient(s);
                        SignatureAndHashAlgorithm signatureAndHashAlgorithm = TlsUtils.chooseSignatureAndHashAlgorithm(ProvTlsClient.this.context, ProvTlsClient.this.supportedSignatureAlgorithms, s2);
                        return new JcaDefaultTlsCredentialedSigner(new TlsCryptoParameters(ProvTlsClient.this.context), (JcaTlsCrypto)tlsCrypto, privateKey, certificate, signatureAndHashAlgorithm);
                    }
                }
                throw new TlsFatalAlert(80);
            }

            public void notifyServerCertificate(TlsServerCertificate tlsServerCertificate) throws IOException {
                String string;
                boolean bl;
                boolean bl2 = bl = tlsServerCertificate == null || tlsServerCertificate.getCertificate() == null || tlsServerCertificate.getCertificate().isEmpty();
                if (bl) {
                    throw new TlsFatalAlert(40);
                }
                X509Certificate[] x509CertificateArray = JsseUtils.getX509CertificateChain(ProvTlsClient.this.manager.getContextData().getCrypto(), tlsServerCertificate.getCertificate());
                if (!ProvTlsClient.this.manager.isServerTrusted(x509CertificateArray, string = JsseUtils.getAuthTypeServer(TlsUtils.getKeyExchangeAlgorithm(ProvTlsClient.this.selectedCipherSuite)))) {
                    throw new TlsFatalAlert(42);
                }
            }
        };
    }

    public int[] getCipherSuites() {
        return TlsUtils.getSupportedCipherSuites(this.manager.getContextData().getCrypto(), this.manager.getContext().convertCipherSuites(this.sslParameters.getCipherSuites()));
    }

    public short[] getCompressionMethods() {
        short[] sArray;
        if (this.manager.getContext().isFips()) {
            short[] sArray2 = new short[1];
            sArray = sArray2;
            sArray2[0] = 0;
        } else {
            sArray = super.getCompressionMethods();
        }
        return sArray;
    }

    public ProtocolVersion getMinimumVersion() {
        return this.manager.getContext().getMinimumVersion(this.sslParameters.getProtocols());
    }

    public ProtocolVersion getClientVersion() {
        return this.manager.getContext().getMaximumVersion(this.sslParameters.getProtocols());
    }

    public TlsSession getSessionToResume() {
        TlsSession tlsSession;
        ProvSSLSessionContext provSSLSessionContext = this.manager.getContextData().getClientSessionContext();
        this.sslSession = provSSLSessionContext.getSessionImpl(this.manager.getPeerHost(), this.manager.getPeerPort());
        if (this.sslSession != null && (tlsSession = this.sslSession.getTlsSession()) != null) {
            return tlsSession;
        }
        if (!this.manager.getEnableSessionCreation()) {
            throw new IllegalStateException("No resumable sessions and session creation is disabled");
        }
        return null;
    }

    public void notifyAlertRaised(short s, short s2, String string, Throwable throwable) {
        Level level;
        super.notifyAlertRaised(s, s2, string, throwable);
        Level level2 = s == 1 ? Level.FINE : (level = s2 == 80 ? Level.WARNING : Level.INFO);
        if (LOG.isLoggable(level)) {
            String string2 = JsseUtils.getAlertLogMessage("Client raised", s, s2);
            if (string != null) {
                string2 = string2 + ": " + string;
            }
            LOG.log(level, string2, throwable);
        }
    }

    public void notifyAlertReceived(short s, short s2) {
        Level level;
        super.notifyAlertReceived(s, s2);
        Level level2 = level = s == 1 ? Level.FINE : Level.INFO;
        if (LOG.isLoggable(level)) {
            String string = JsseUtils.getAlertLogMessage("Client received", s, s2);
            LOG.log(level, string);
        }
    }

    public synchronized void notifyHandshakeComplete() throws IOException {
        this.handshakeComplete = true;
        TlsSession tlsSession = this.context.getSession();
        if (this.sslSession == null || this.sslSession.getTlsSession() != tlsSession) {
            this.sslSession = this.manager.getContextData().getClientSessionContext().reportSession(tlsSession, this.manager.getPeerHost(), this.manager.getPeerPort());
        }
        this.manager.notifyHandshakeComplete(new ProvSSLConnection(this.context, this.sslSession));
    }

    public void notifySecureRenegotiation(boolean bl) throws IOException {
        boolean bl2;
        if (!bl && !(bl2 = PropertyUtils.getBooleanSystemProperty("sun.security.ssl.allowLegacyHelloMessages", true))) {
            throw new TlsFatalAlert(40);
        }
    }

    public void notifySelectedCipherSuite(int n) {
        this.manager.getContext().validateNegotiatedCipherSuite(n);
        super.notifySelectedCipherSuite(n);
        LOG.fine("Client notified of selected cipher suite: " + this.manager.getContext().getCipherSuiteString(n));
    }

    public void notifyServerVersion(ProtocolVersion protocolVersion) throws IOException {
        String string = this.manager.getContext().getProtocolString(protocolVersion);
        if (string != null) {
            for (String string2 : this.sslParameters.getProtocols()) {
                if (!string.equals(string2)) continue;
                LOG.fine("Client notified of selected protocol version: " + string);
                return;
            }
        }
        throw new TlsFatalAlert(70);
    }

    public void notifySessionID(byte[] byArray) {
        super.notifySessionID(byArray);
        if (byArray == null || byArray.length == 0) {
            LOG.fine("Server did not specify a session ID");
        } else if (this.sslSession != null && Arrays.areEqual(byArray, this.sslSession.getId())) {
            LOG.fine("Server resumed session: " + Hex.toHexString(byArray));
        } else {
            if (!this.manager.getEnableSessionCreation()) {
                throw new IllegalStateException("Server did not resume session and session creation is disabled");
            }
            LOG.fine("Server specified new session: " + Hex.toHexString(byArray));
        }
    }
}

