/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.edec.examples.ws;

import ch.admin.bit.edec.examples.PropertyProvider;
import ch.admin.bit.edec.examples.fileHandling.FileHandler;
import ch.admin.bit.edec.examples.ws.AbstractRequest;
import ch.admin.bit.edec.examples.ws.SslConnectionParams;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.util.EntityUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jsse.provider.BouncyCastleJsseProvider;

public class HttpsRequest
extends AbstractRequest {
    private static final Log log = LogFactory.getLog(HttpsRequest.class);
    private static final String HEADER_NAME_SSL_HEADER_ADDITION = "SSL_CLIENT_CERT_S_DN_CN";
    private static final String HEADER_NAME_HOST = "Host";
    private static final String HEADER_NAME_CONTENT_TYPE = "Content-Type";
    private static final String HEADER_NAME_SOAP_ACTION = "SOAPAction";
    private static final String[] CYPHER_SUITE = new String[]{"TLS_DHE_RSA_WITH_AES_128_CBC_SHA"};
    private static final String[] TLS_VERSIONS = new String[]{"TLSv1", "TLSv1.1", "TLSv1.2"};
    private static final String CONTENT_TYPE = "text/xml;charset=UTF-8";
    private static final String DEFAULT_PROVIDER_NAME = "BC";
    private static final String DEFAULT_JSSE_PROVIDER_NAME = "BCJSSE";
    static TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) {
        }
    }};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doRequest(SslConnectionParams connParams) throws IOException {
        StringBuilder responseStringBuilder = new StringBuilder();
        BufferedReader reader = null;
        Closeable httpClient = null;
        if (PropertyProvider.getProperty("security.provider.bouncycastle.enabled").equalsIgnoreCase("true")) {
            HttpsRequest.setProvider();
        }
        try {
            InputStream truststoreInput = Thread.currentThread().getContextClassLoader().getResourceAsStream(connParams.getTruststorePath());
            InputStream keystoreInput = Thread.currentThread().getContextClassLoader().getResourceAsStream(connParams.getKeystorePath());
            KeyStore trustStore = FileHandler.loadStore(truststoreInput, connParams.getTruststorePassword());
            KeyStore keyStore = FileHandler.loadStore(keystoreInput, connParams.getKeystorePassword());
            SSLContextBuilder contextBuilder = SSLContexts.custom();
            contextBuilder.loadTrustMaterial(trustStore, new TrustSelfSignedStrategy());
            contextBuilder.loadKeyMaterial(keyStore, connParams.getIdentityPassword().toCharArray());
            SSLContext sslcontext = contextBuilder.build();
            log.info("Using Provider: " + sslcontext.getProvider().getName());
            HostnameVerifier hnv = new HostnameVerifier(){

                @Override
                public boolean verify(String string, SSLSession ssls) {
                    return true;
                }
            };
            SSLConnectionSocketFactory sslConnectionFactory = new SSLConnectionSocketFactory(sslcontext, TLS_VERSIONS, null, hnv);
            Registry<SSLConnectionSocketFactory> socketFactoryRegistry = RegistryBuilder.create().register("https", sslConnectionFactory).build();
            HttpClientBuilder builder = HttpClientBuilder.create();
            builder.setSSLSocketFactory(sslConnectionFactory);
            httpClient = builder.build();
            HttpPost httpPost = new HttpPost(connParams.getUrl().toURI());
            httpPost.setHeader(HEADER_NAME_HOST, connParams.getHost());
            if (!"".equals(connParams.getSslHeaderAddition())) {
                httpPost.setHeader(HEADER_NAME_SSL_HEADER_ADDITION, connParams.getSslHeaderAddition());
            }
            httpPost.setHeader(HEADER_NAME_CONTENT_TYPE, CONTENT_TYPE);
            httpPost.setHeader(HEADER_NAME_SOAP_ACTION, "\"" + connParams.getSoapAction() + "\"");
            httpPost.setEntity(new StringEntity(connParams.getRequest(), ContentType.create("text/xml", StandardCharsets.UTF_8.name())));
            log.info("Server response: " + response.getStatusLine());
            try (CloseableHttpResponse response = ((CloseableHttpClient)httpClient).execute(httpPost);){
                HttpEntity entity = response.getEntity();
                InputStream input = entity.getContent();
                reader = new BufferedReader(new InputStreamReader(input));
                responseStringBuilder = HttpsRequest.createResponse(reader);
                EntityUtils.consume(entity);
            }
        }
        catch (URISyntaxException e) {
            log.error(e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            log.error(e.getMessage());
        }
        catch (KeyStoreException e) {
            log.error(e.getMessage());
        }
        catch (KeyManagementException e) {
            log.error(e.getMessage());
        }
        catch (Throwable e) {
            log.error(e.getMessage());
        }
        finally {
            httpClient.close();
            if (PropertyProvider.getProperty("security.provider.bouncycastle.enabled").equalsIgnoreCase("true")) {
                HttpsRequest.removeProvider();
            }
        }
        return responseStringBuilder.toString();
    }

    private static void setProvider() {
        try {
            Security.removeProvider(DEFAULT_PROVIDER_NAME);
            Security.insertProviderAt(new BouncyCastleProvider(), 1);
            log.info("Added BouncyCastleProvider.");
            Security.removeProvider(DEFAULT_JSSE_PROVIDER_NAME);
            Security.insertProviderAt(new BouncyCastleJsseProvider(), 2);
            log.info("Added BouncyCastleJsseProvider.");
        }
        catch (Exception ex) {
            log.error("Couldn't register BC provider!");
        }
        HttpsRequest.printProviders();
    }

    private static void removeProvider() {
        if (Security.getProvider(DEFAULT_PROVIDER_NAME) != null) {
            Security.removeProvider(DEFAULT_PROVIDER_NAME);
            log.info("Removed BouncyCastleProvider.");
        }
        if (Security.getProvider(DEFAULT_JSSE_PROVIDER_NAME) != null) {
            Security.removeProvider(DEFAULT_JSSE_PROVIDER_NAME);
            log.info("Removed BouncyCastleJsseProvider.");
        }
    }

    private static void printProviders() {
        log.info("-----------------------------------------------");
        log.info("Registered Providers");
        for (Provider p : Security.getProviders()) {
            log.info("  - " + p.getName());
        }
        log.info("-----------------------------------------------");
    }
}

