/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.edec.examples.ws;

import ch.admin.bit.edec.examples.ws.AbstractRequest;
import ch.admin.bit.edec.examples.ws.ConnectionParams;
import ch.admin.bit.edec.examples.ws.HttpsRequest;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import javax.net.ssl.HttpsURLConnection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HttpRequest
extends AbstractRequest {
    private static final Log log = LogFactory.getLog(HttpsRequest.class);

    public static String doRequest(ConnectionParams connParams) throws IOException {
        HttpURLConnection connection = null;
        try {
            log.info("Opening connection...");
            connection = (HttpURLConnection)connParams.getUrl().openConnection();
            log.info("Http connection established.");
        }
        catch (IOException e) {
            log.error("Couldn't open a connection! " + e.getMessage());
            throw e;
        }
        HttpRequest.setConnectionParameters(connection, connParams);
        connection.setRequestMethod(connParams.getRequestMethod());
        StringBuilder responseStringBuilder = HttpRequest.sendRequest(connection, connParams);
        connection = null;
        return responseStringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static StringBuilder sendRequest(URLConnection connection, ConnectionParams connParams) {
        StringBuilder response = new StringBuilder();
        Writer wr = null;
        BufferedReader reader = null;
        InputStream errorStream = null;
        try {
            OutputStream output = connection.getOutputStream();
            OutputStreamWriter osw = new OutputStreamWriter(output, "UTF-8");
            wr = new BufferedWriter(osw);
            InputStream input = connection.getInputStream();
            reader = new BufferedReader(new InputStreamReader(input));
            log.info("  Making request...");
            wr.write(connParams.getRequest());
            wr.flush();
            log.info("  SOAP message successfully sent to " + connParams.getUrl());
            log.info("  Forming response...");
            response = HttpRequest.createResponse(reader);
        }
        catch (IOException ex) {
            log.error("Received error response or something else went wrong:" + SEP + "Exception Message is: " + ex.getMessage());
            response.append(ex);
            try {
                if (connection instanceof HttpURLConnection) {
                    errorStream = ((HttpURLConnection)connection).getErrorStream();
                } else if (connection instanceof HttpsURLConnection) {
                    errorStream = ((HttpsURLConnection)connection).getErrorStream();
                }
                HttpRequest.createError(response, errorStream);
            }
            catch (IOException eex) {
                log.error("Unexpected Error while reading error stream: " + eex.getMessage());
            }
        }
        finally {
            try {
                if (wr != null) {
                    log.debug("Closing writer.");
                    wr.close();
                }
            }
            catch (IOException iOException) {
            }
            finally {
                wr = null;
            }
            try {
                if (reader != null) {
                    log.debug("Closing reader.");
                    reader.close();
                }
            }
            catch (IOException iOException) {
            }
            finally {
                reader = null;
            }
            try {
                if (errorStream != null) {
                    log.debug("Closing error stream.");
                    errorStream.close();
                }
            }
            catch (IOException iOException) {
            }
            finally {
                errorStream = null;
            }
        }
        return response;
    }

    private static void setConnectionParameters(URLConnection connection, ConnectionParams connParams) {
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.setRequestProperty("Host", connParams.getHost());
        if (!"".equals(connParams.getSslHeaderAddition())) {
            connection.setRequestProperty("SSL_CLIENT_CERT_S_DN_CN", connParams.getSslHeaderAddition());
        }
        connection.setRequestProperty("Content-Type", "text/xml; charset=utf-8");
        connection.setRequestProperty("Content-Length", "" + connParams.getRequest().length());
        connection.setRequestProperty("SOAPAction", "\"" + connParams.getSoapAction() + "\"");
        log.debug("Connection Host: " + connParams.getHost());
        log.debug("Connection SSL_CLIENT_CERT_S_DN_CN: " + connParams.getSslHeaderAddition());
        log.debug("Connection Content-Type: text/xml; charset=utf-8");
        log.debug("Connection Content-Length: " + connParams.getRequest().length());
        log.debug("Connection SOAPAction: " + connParams.getSoapAction());
    }
}

