/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.edec.examples;

import ch.admin.bit.edec.examples.ws.HttpsRequest;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PropertyProvider {
    private static final Log log = LogFactory.getLog(HttpsRequest.class);
    public static final String PROPERTY_FILE = "config.properties";
    private static Properties properties;
    private static PropertyProvider provider;
    public static final String PROP_WS_PATH_BORDEREAU = "ws.path.bordereau";
    public static final String PROP_WS_PATH_RECEIPT = "ws.path.receipt";
    public static final String PROP_WS_PATH_EDEC = "ws.path.edec";
    public static final String PROP_KEYSTORE_PATH = "ws.keystore.path";
    public static final String PROP_KEYSTORE_PASSWORD = "ws.keystore.password";
    public static final String PROP_TRUSTSTORE_PATH = "ws.truststore.path";
    public static final String PROP_TRUSTSTORE_PASSWORD = "ws.truststore.password";
    public static final String PROP_WS_SSL_HEADER_ADDITION = "ws.ssl.header.addition";
    public static final String PROP_WS_PROTOCOL = "ws.protocol";
    public static final String PROP_WS_SOAP_ACTION = "ws.soap.action";
    public static final String PROP_WS_PORT = "ws.port";
    public static final String PROP_WS_HOST = "ws.host";
    public static final String PROP_SOAP_ENVELOPE_FILE = "request.soap.envelope";
    public static final String PROP_IDENTITY_PASSWORD = "identity.password";
    public static final String PROP_USE_BOUNCYCASTLE = "security.provider.bouncycastle.enabled";

    private PropertyProvider() {
    }

    public static void initialize() {
        if (null == provider) {
            provider = new PropertyProvider();
        }
    }

    public static String getProperty(String name) {
        if (null == properties) {
            return null;
        }
        Object value = properties.get(name);
        return (String)value;
    }

    public static Properties load(String propertyFileName) {
        Properties props = null;
        try {
            props = PropertyProvider.read(propertyFileName);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return props;
    }

    public static Properties read(String propertyFileName) throws IOException {
        Properties props = new Properties();
        URL res = PropertyProvider.class.getResource(propertyFileName);
        if (null == res) {
            log.error("Could not find property file '" + propertyFileName + "'!");
        }
        log.info("Found property file '" + propertyFileName + "'.");
        try {
            URI uri = res.toURI();
            InputStream is = Files.newInputStream(Paths.get(uri), new OpenOption[0]);
            props.load(is);
        }
        catch (URISyntaxException ex) {
            log.error(ex);
        }
        catch (IOException ex) {
            log.error(ex);
        }
        return props;
    }

    public static void loadDirect(String propertyFileName) {
        try {
            properties = new Properties();
            FileInputStream fis = new FileInputStream(propertyFileName);
            properties.load(fis);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

