package ch.admin.bit.edec.dsig.util;

import ch.admin.bit.edec.dsig.TestUtil;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import javax.xml.xpath.XPathExpressionException;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

/**
 * Test for the class {@link XMLUtil}.
 */
public class XMLUtilTest {

  private Document document;

  @Before public void setUp() throws Exception {
    document = XMLUtil.read(TestUtil.getFile(TestUtil.VALID_EVV));
  }

  @Test public void testRead() {
    assertNotNull(document);
  }

  @Test public void testExtractX509Token() throws XPathExpressionException {
    Node node = XMLUtil.extractX509Token(document);
    assertNotNull(node);
    assertEquals("BinarySecurityToken", node.getLocalName());
  }

  @Test public void testExtractDSignature() throws XPathExpressionException {
    Node node = XMLUtil.extractDSignature(document);
    assertNotNull(node);
    assertEquals("Signature", node.getLocalName());
  }

  @Test public void testExtractTimeStamp() throws XPathExpressionException {
    Node node = XMLUtil.extractTimeStamp(document);
    assertNotNull(node);
    assertEquals("Created", node.getLocalName());
  }

  @Test public void testExtractDocumentInformation() throws XPathExpressionException {
    Node node = XMLUtil.extractDocumentInformation(document);
    assertNotNull(node);
    assertEquals("documentInformation", node.getLocalName());
  }

  @Test public void testExtractTraderDeclarationNumber() throws XPathExpressionException {
    Node node = XMLUtil.extractTraderDeclarationNumber(document);
    assertNotNull(node);
    assertEquals("traderDeclarationNumber", node.getLocalName());
  }

  @Test public void testExtractTraderReference() throws XPathExpressionException {
    Node node = XMLUtil.extractTraderReference(document);
    assertNotNull(node);
    assertEquals("traderReference", node.getLocalName());
  }

  @Test public void testExtractDeclaratTIN() throws XPathExpressionException {
    NodeList nodeList = XMLUtil.extractDeclaratTIN(document);
    assertNotNull(nodeList);
    assertEquals(3, nodeList.getLength());
    assertEquals("traderIdentificationNumber", nodeList.item(0).getLocalName());
  }

}
