package ch.admin.bit.edec.dsig.builder;

import ch.admin.bit.edec.dsig.TestUtil;
import ch.admin.bit.edec.dsig.util.XMLUtil;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;

import java.security.cert.X509Certificate;

import static org.junit.Assert.assertNotNull;

/**
 * Tests for the class {@link X509CertificateBuilder}.
 */
public class X509CertificateBuilderTest {

  private X509CertificateBuilder builder;

  @Before public void setUp() {
    builder = new X509CertificateBuilder(TestUtil.createSystemContext());
  }

  @Test public void testCreateCertificate() throws Exception {
    Document document = XMLUtil.read(TestUtil.getFile(TestUtil.VALID_EVV));
    X509Certificate x509Certificate = builder.createCertificate(XMLUtil.extractX509Token(document).getTextContent());
    assertNotNull(x509Certificate);
  }

  @Test public void testCreateCertificateFromPath() throws Exception {
    X509Certificate x509Certificate = builder.createCertificateFromPath(TestUtil.getFile(TestUtil.SWISS_GOV_CA));
    assertNotNull(x509Certificate);
  }

}
