package ch.admin.bit.edec.dsig;

import ch.admin.bit.edec.dsig.context.ProviderSelectorImpl;
import ch.admin.bit.edec.dsig.context.SystemContext;
import ch.admin.bit.edec.dsig.context.SystemContextImpl;
import ch.admin.bit.edec.dsig.out.StringBufferOutputter;

/**
 * Utility class including test constants.
 */
public class TestUtil {

  public static final String VALID_EVV = "/valid_evv.xml";

  public static final String SWISS_GOV_CA = "/cert/Swiss+Government+Regular+CA+01.cer";

  public static final String SWISS_GOV_CRL = "/cert/RegularCA01.crl";

  /**
   * Private constructor to hide implicit public one.
   */
  private TestUtil() {
  }

  public static String getFile(String fileName) {
    return TestUtil.class.getResource(fileName).getFile();
  }

  public static SystemContext createSystemContext() {
    SystemContextImpl systemContext = new SystemContextImpl();
    systemContext.setOutputterStrategy(new StringBufferOutputter());
    systemContext.setProviderSelector(new ProviderSelectorImpl());
    return systemContext;
  }

}
