package ch.admin.bit.edec.dsig;

import ch.admin.bit.edec.dsig.util.XMLUtil;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;

import static org.junit.Assert.assertNull;
import static org.junit.Assert.assertTrue;

/**
 * Tests für die Klasse {@link SignatureValidator}.
 */
public class SignatureValidatorTest {

  private SignatureValidator validator;

  @Before public void setUp() {
    validator = new SignatureValidator(TestUtil.getFile(TestUtil.SWISS_GOV_CA),
        TestUtil.getFile(TestUtil.SWISS_GOV_CRL));
  }

  @Test public void test() throws Exception {
    Document document = XMLUtil.read(TestUtil.getFile(TestUtil.VALID_EVV));
    ValidationResult result = validator.validate(document);

    assertTrue(result.isValid());
    assertNull(result.getException());
  }

}
