/*
 *  Name:    $Id: EditPopupMenu.java,v 1.1 2010/02/01 10:29:12 t724w Exp $
 * 
 *  Copyright 2009 Bundesamt für Informatik und Telekommunikation
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package ch.admin.bit.edec.evv.ui.swing;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.text.JTextComponent;

import ch.admin.bit.edec.dsig.Environment;

/**
 * 
 * Cut, copy and paste popup menu
 * 
 * @author mru
 * 
 */
public class EditPopupMenu extends JPopupMenu {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	public EditPopupMenu(final JTextComponent component) {

		JMenuItem cut = createMenuItem("Cut", "/edit-cut.png");
		add(cut);

		cut.addActionListener(new ActionListener() {

			public void actionPerformed(ActionEvent e) {
				component.cut();
			}
		});

		JMenuItem copy = createMenuItem("Copy", "/edit-copy.png");
		add(copy);

		copy.addActionListener(new ActionListener() {

			public void actionPerformed(ActionEvent e) {
				component.copy();
			}
		});

		JMenuItem paste = createMenuItem("Paste", "/edit-paste.png");
		add(paste);

		paste.addActionListener(new ActionListener() {

			public void actionPerformed(ActionEvent e) {
				component.paste();
			}
		});

	}

	private JMenuItem createMenuItem(String menuName, String iconPath) {
		ImageIcon icon = Environment.createImageIcon(iconPath);
		JMenuItem item = null;

		if (icon != null) {

			item = new JMenuItem(menuName, icon);

		} else {
			item = new JMenuItem(menuName);
		}

		return item;
	}
}
