/*
 *  Name:    $Id: X509CRLValidator.java,v 1.2 2010/01/07 14:57:51 t724w Exp $
 * 
 *  Copyright 2009 Bundesamt für Informatik und Telekommunikation
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package ch.admin.bit.edec.dsig.validator;

import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;

/**
 * Checks if a certificate was revoked. This is a simple implementation and the
 * date and public key from the CRL are not validated.
 * 
 * @author t724w (mru)
 * 
 */
public class X509CRLValidator {

	private X509CRL x509crl;

	/**
	 * 
	 * @param x509crl
	 */
	public X509CRLValidator(X509CRL x509crl) {

		this.x509crl = x509crl;
	}

	/**
	 * Returns true if the certificate was not revoked
	 * 
	 * @param cert
	 * @return true certificate was not revoked (valid) or false when
	 *         certificate was revoked (invalid).
	 */
	public boolean isValid(X509Certificate cert) {

		if (x509crl.isRevoked(cert)) {
			// certificate was revoked
			return false;
		} else {
			// certificate is not revoked
			return true;
		}
	}

}
