/*
 *  Name:    $Id: NamespaceContextImpl.java,v 1.2 2010/01/07 14:57:52 t724w Exp $
 * 
 *  Copyright 2009 Bundesamt für Informatik und Telekommunikation
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package ch.admin.bit.edec.dsig.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import javax.xml.namespace.NamespaceContext;

/**
 * NamespaceContext Implementation with all required namespaces for the e-dec
 * receipt response
 * 
 * @author t724w (mru)
 * 
 */
public class NamespaceContextImpl implements NamespaceContext {

	public static final String NS_URI_WSSE = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd";
	public static final String PREFIX_WSSE = "wsse";

	public static final String NS_URI_SOAP_ENV = "http://schemas.xmlsoap.org/soap/envelope/";
	public static final String PREFIX_SOAP_ENV = "soap";

	public static final String NS_URI_XMLDSIG = "http://www.w3.org/2000/09/xmldsig#";
	public static final String PREFIX_XMLDSIG = "ds";

	public static final String NS_URI_WSU = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd";
	public static final String PREFIX_WSU = "wsu";

	// public static final String NS_URI_EVV =
	// "http://www.e-dec.ch/xml/schema/edecReceiptResponse/v1";
	// public static final String PREFIX_EVV = "evv";

	private Map<String, String> value = new HashMap<String, String>();

	public NamespaceContextImpl() {

		// value.put(PREFIX_EVV, NS_URI_EVV); // not used
		value.put(PREFIX_SOAP_ENV, NS_URI_SOAP_ENV);
		value.put(PREFIX_WSSE, NS_URI_WSSE);
		value.put(PREFIX_WSU, NS_URI_WSU);
		value.put(PREFIX_XMLDSIG, NS_URI_XMLDSIG);

	}

	/**
	 * (non-Javadoc)
	 * 
	 * @see javax.xml.namespace.NamespaceContext#getNamespaceURI(java.lang.String)
	 */
	public String getNamespaceURI(String prefix) {
		return value.get(prefix);
	}

	/**
	 * (non-Javadoc)
	 * 
	 * @see javax.xml.namespace.NamespaceContext#getPrefix(java.lang.String)
	 */
	public String getPrefix(String uri) {
		for (String prefix : value.keySet()) {
			String u = value.get(prefix);

			if (u.equals(uri)) {
				return prefix;
			}

		}
		return null;
	}

	/**
	 * NOT SUPPORTED
	 * 
	 * @throws UnsupportedOperationException
	 */
	public Iterator<String> getPrefixes(String uri) {
		throw new UnsupportedOperationException();
	}

}
