/*
 *  Name:    $Id: StreamOutputter.java,v 1.4 2010/03/02 16:01:39 t724w Exp $
 * 
 *  Copyright 2009 Bundesamt für Informatik und Telekommunikation
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package ch.admin.bit.edec.dsig.out;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;

import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * Simple abstract class for writing some data into an ouput stream
 * 
 * @author t724w (mru)
 * 
 */
public abstract class StreamOutputter implements OutputterStrategy {

	protected PrintWriter writer;

	/**
	 * {@link OutputStream} on which should be written
	 * 
	 * @param os
	 */
	public StreamOutputter(OutputStream os) {
		writer = new PrintWriter(os);
	}

	public void write(String str) {
		writer.println(str);
	}

	public void write(String prefix, X509Certificate cert) {
		if (cert != null) {
			writer.println(prefix + " issuer DN: " + cert.getIssuerDN());
			writer.println(prefix + " subject DN: " + cert.getSubjectDN());
			writer.println(prefix + " valid from: " + cert.getNotBefore());
			writer.println(prefix + " valid to: " + cert.getNotAfter());
		} else {
			writer.println(prefix + " NOT SET");
		}

	}

	public void write(String prefix, X509CRL crl) {
		if (crl != null) {
			writer.println(prefix + " issuer DN: " + crl.getIssuerDN());
			writer.println(prefix + " valid from: " + crl.getThisUpdate());
			writer.println(prefix + " next update: " + crl.getNextUpdate());
			// System.out.println(prefix + " revoked certificates: " +
			// crl.getRevokedCertificates().size());
		} else {
			writer.println(prefix + " NOT SET");
		}

	}

	public void write(NodeList list) {

		if (list != null) {
			int size = list.getLength();
			for (int i = 0; i < size; i++) {
				Node current = list.item(i);

				if (Node.ELEMENT_NODE == current.getNodeType()) {
					writer.println(current.getLocalName() + ": "
							+ current.getTextContent());
				}
			}
		}

	}

	public void write(Node node) {
		if (node != null) {
			writer.println(node.getLocalName() + ": " + node.getTextContent());
		}

	}

	public void write(String prefix, Throwable ex) {
		if (ex != null) {
			writer.println(prefix + ": " + ex.toString());
			for (StackTraceElement ste : ex.getStackTrace()) {
				writer.println("   " + ste.toString());
			}
		}

	}

	public void close() {
		writer.close();
	}

}
