/*
 *  Name:    $Id: OutputterStrategy.java,v 1.4 2010/03/02 16:01:39 t724w Exp $
 * 
 *  Copyright 2009 Bundesamt für Informatik und Telekommunikation
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package ch.admin.bit.edec.dsig.out;

import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;

import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * 
 * This interfaces must be implemented when an new {@link OutputterStrategy} is
 * needed. There are some default implementation for a console output and file
 * output.
 * 
 * @see StreamOutputter
 * @see FileOutputter
 * @see ConsoleOutputter
 * 
 * @author t724w (mru)
 * 
 */
public interface OutputterStrategy {

	/**
	 * Write a string
	 * 
	 * @param str
	 *            output string
	 */
	public void write(String str);

	/**
	 * Write a certificate
	 * 
	 * @param prefix
	 *            the prefix for the print out
	 * @param cert
	 *            certificate
	 */
	public void write(String prefix, X509Certificate cert);

	/**
	 * Write a CRL
	 * 
	 * @param prefix
	 *            the prefix which should be printed
	 * @param crl
	 *            the CRL to print out
	 */
	public void write(String prefix, X509CRL crl);

	/**
	 * Write a node list
	 * 
	 * @param list
	 *            the node list to print
	 */
	public void write(NodeList list);

	/**
	 * Write a node
	 * 
	 * @param node
	 *            the node to write out
	 */
	public void write(Node node);

	/**
	 * Write an exception
	 * 
	 * @param prefix
	 *            the prefix which should be printed out
	 * @param ex
	 *            the exception
	 */
	public void write(String prefix, Throwable ex);

	/**
	 * Close stream
	 */
	public void close();

}
