/*
 *  Name:    $Id: ProviderSelectorImpl.java,v 1.4 2010/01/07 14:57:52 t724w Exp $
 * 
 *  Copyright 2009 Bundesamt für Informatik und Telekommunikation
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package ch.admin.bit.edec.dsig.context;

import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertPathValidator;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;

/**
 * This class is used to switch between the jce/jca provider. In this
 * implementation the default JRE jce/jca provider is returned.
 * 
 * @author t724w (mru)
 * 
 */
public class ProviderSelectorImpl implements ProviderSelector {

	// name of the bouncycastle provider
	// private static final String BC_PROVIDER = "BC";
	// bouncycastle provider class
	// private static final String BC_PROVIDER_CLASS =
	// "org.bouncycastle.jce.provider.BouncyCastleProvider";

	private static final String X_509 = "X.509";

	// default to not use BC
	// private static boolean bcInstalled = false;

	//
	// initialize bouncycastle when installed
	//
	// static {
	// try {
	// // register bouncycastle provider
	// Security.addProvider((Provider)
	// (Class.forName(BC_PROVIDER_CLASS).newInstance()));
	// // bc was successful installed
	// bcInstalled = true;
	//      
	// }
	// catch (Exception e) {
	// // do nothing bouncycastle was not found --> use default Java SE
	// implementation
	// }
	// }

	/*
	 * (non-Javadoc)
	 * 
	 * @see ch.admin.bit.edec.xmldsig.ProviderSelector#getCertPathValidator()
	 */
	public CertPathValidator getCertPathValidator()
			throws NoSuchAlgorithmException, NoSuchProviderException {
		// if (bcInstalled) {
		// return CertPathValidator.getInstance("PKIX", BC_PROVIDER);
		// }
		// else {
		return CertPathValidator.getInstance("PKIX");
		// }
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * ch.admin.bit.edec.xmldsig.ProviderSelector#getCertStore(java.security
	 * .cert.CertStoreParameters)
	 */
	public CertStore getCertStore(CertStoreParameters certStoreParams)
			throws InvalidAlgorithmParameterException,
			NoSuchAlgorithmException, NoSuchProviderException {
		// if (bcInstalled) {
		// return CertStore.getInstance("Collection", certStoreParams,
		// BC_PROVIDER);
		// }
		// else {
		return CertStore.getInstance("Collection", certStoreParams);
		// }
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see ch.admin.bit.edec.xmldsig.ProviderSelector#getCertificateFactory()
	 */
	public CertificateFactory getCertificateFactory()
			throws CertificateException, NoSuchProviderException {
		// IF (BCINSTALLED) {
		// RETurn CertificateFactory.getInstance(X_509, BC_PROVIDER);
		// }
		// else {
		return CertificateFactory.getInstance(X_509);
		// }
	}

}
