/*
 *  Name:    $Id: X509CRLBuilder.java,v 1.3 2010/01/27 16:01:10 t724w Exp $
 *
 *  Copyright 2009 Bundesamt fr Informatik und Telekommunikation
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package ch.admin.bit.edec.dsig.builder;

import ch.admin.bit.edec.dsig.context.SystemContext;

import java.io.*;
import java.security.NoSuchProviderException;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;

/**
 * This is a builder class for x509 CRL's
 *
 * @author t724w (mru)
 */
public class X509CRLBuilder {

  private SystemContext context;

  /**
   * @param context
   */
  public X509CRLBuilder(SystemContext context) {
    this.context = context;
  }

  /**
   * Create a CRL from a given file path
   *
   * @param path
   * @return
   * @throws FileNotFoundException
   * @throws CRLException
   * @throws CertificateException
   * @throws NoSuchProviderException
   */
  public X509CRL createCRLFromPath(String path)
      throws FileNotFoundException, CertificateException, NoSuchProviderException, CRLException {

    InputStream is = new FileInputStream(new File(path));
    CertificateFactory cf = context.getProviderSelector().getCertificateFactory();

    X509CRL crl = (X509CRL) cf.generateCRL(is);
    try {
      is.close();
    }
    catch (IOException e) {
      // do nothing
    }
    return crl;
  }

}
