/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.edec.evv.ui.swing;

import ch.admin.bit.edec.dsig.Environment;
import ch.admin.bit.edec.dsig.ValidationResult;
import ch.admin.bit.edec.dsig.out.ByteArrayOutputter;
import ch.admin.bit.edec.evv.ui.EVVValidator;
import ch.admin.bit.edec.evv.ui.swing.EditPopupMenuMouseListener;
import ch.admin.bit.edec.evv.ui.swing.FileInputChangedListener;
import ch.admin.bit.edec.evv.ui.swing.FileInputType;
import ch.admin.bit.edec.evv.ui.swing.MainApp;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class OperationPanel
extends JPanel
implements FileInputChangedListener {
    private static final int TEXT_LENGTH = 20;
    private String inputFile;
    private String inputCRL;
    private String inputCA;
    private JTextArea textArea;
    private JTextField status;
    private JLabel statusIcon;
    private JFileChooser fileChooser = new JFileChooser();
    private static final long serialVersionUID = 1L;

    public OperationPanel(MainApp mainApp) {
        JLabel label = new JLabel("Status:");
        this.status = new JTextField(20);
        label.setLabelFor(this.status);
        this.status.setEditable(false);
        this.status.setBackground(Color.WHITE);
        this.setLayout(new GridLayout(0, 1));
        this.textArea = new JTextArea();
        JScrollPane scrollPane = new JScrollPane(this.textArea);
        this.textArea.setEditable(false);
        this.textArea.addMouseListener(new EditPopupMenuMouseListener());
        this.add(scrollPane);
        JPanel buttons = new JPanel();
        buttons.setLayout(new FlowLayout(0));
        buttons.add(this.createValidateButton());
        buttons.add(this.createSaveButton());
        buttons.add(label);
        buttons.add(this.status);
        ImageIcon icon = Environment.createImageIcon("/info.png");
        if (icon != null) {
            this.statusIcon = new JLabel(icon);
            buttons.add(this.statusIcon);
        }
        mainApp.add((Component)buttons, "South");
    }

    @Override
    public void onFilePathChanged(String path, FileInputType source) {
        switch (source) {
            case CA: {
                this.inputCA = path;
                break;
            }
            case CRL: {
                this.inputCRL = path;
                break;
            }
            case EVV: {
                this.inputFile = path;
                break;
            }
        }
    }

    private JButton createSaveButton() {
        JButton button = new JButton();
        button.setText("save log");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OperationPanel.this.showSaveDialog();
            }
        });
        return button;
    }

    private JButton createValidateButton() {
        JButton button = new JButton();
        button.setText("validate");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OperationPanel.this.validateEVV();
            }
        });
        return button;
    }

    private void validateEVV() {
        ImageIcon icon;
        EVVValidator evvValidator = new EVVValidator();
        ByteArrayOutputStream bas = new ByteArrayOutputStream();
        ByteArrayOutputter buffer = new ByteArrayOutputter(bas);
        evvValidator.addOutputterStrategy(buffer);
        ValidationResult result = evvValidator.validateFromFile(this.inputFile, this.inputCA, this.inputCRL, null, null, false);
        if (result.isValid()) {
            this.status.setBackground(Color.GREEN);
            this.status.setText("OK!");
            icon = Environment.createImageIcon("/valid.png");
            if (icon != null) {
                this.statusIcon.setIcon(icon);
            }
        } else {
            this.status.setBackground(Color.RED);
            this.status.setText("NOT OK!");
            icon = Environment.createImageIcon("/error.png");
            if (icon != null) {
                this.statusIcon.setIcon(icon);
            }
        }
        this.textArea.setText(bas.toString());
        try {
            bas.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void showSaveDialog() {
        int returnVal = this.fileChooser.showSaveDialog(this);
        if (returnVal == 0) {
            File file = this.fileChooser.getSelectedFile();
            String text = this.textArea.getText();
            try {
                FileOutputStream fos = new FileOutputStream(file);
                fos.write(text.getBytes());
                fos.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(this.fileChooser, e.getMessage(), "Error", 0);
            }
        }
    }
}

