/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.edec.evv.ui.swing;

import ch.admin.bit.edec.evv.ui.swing.EditPopupMenuMouseListener;
import ch.admin.bit.edec.evv.ui.swing.FileChooserButton;
import ch.admin.bit.edec.evv.ui.swing.FileInputChangedListener;
import ch.admin.bit.edec.evv.ui.swing.FileInputType;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class FileInputPanel
extends JPanel {
    private static final int TEXT_LENGTH = 40;
    private static final long serialVersionUID = 1L;
    private final List<FileInputChangedListener> listeners;
    private final JFileChooser fileChooser;
    private final FileInputType type;
    private JTextField txtFile;

    public FileInputPanel(final FileInputType type, String value, final List<FileInputChangedListener> listeners) {
        this.listeners = listeners;
        this.type = type;
        this.firePathEvent(value);
        this.setLayout(new FlowLayout(0));
        this.fileChooser = new JFileChooser(value);
        this.txtFile = new JTextField(40);
        this.txtFile.setText(value);
        this.txtFile.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                String path = ((JTextField)e.getSource()).getText();
                FileInputPanel.this.fileChooser.setCurrentDirectory(new File(path));
                for (FileInputChangedListener listener : listeners) {
                    listener.onFilePathChanged(path, type);
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }
        });
        this.txtFile.addMouseListener(new EditPopupMenuMouseListener());
        JLabel lblDescription = new JLabel(type.toString());
        this.add(lblDescription);
        this.add(this.txtFile);
        this.add(new FileChooserButton(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileInputPanel.this.showDialog();
            }
        }));
    }

    private void showDialog() {
        int returnVal = this.fileChooser.showOpenDialog(this);
        if (returnVal == 0) {
            File file = this.fileChooser.getSelectedFile();
            String path = file.getAbsolutePath();
            this.txtFile.setText(path);
            this.firePathEvent(path);
        }
    }

    private void firePathEvent(String path) {
        for (FileInputChangedListener listener : this.listeners) {
            listener.onFilePathChanged(path, this.type);
        }
    }
}

