/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.edec.dsig.validator;

import ch.admin.bit.edec.dsig.context.SystemContext;
import java.security.Provider;
import java.security.PublicKey;
import java.util.Iterator;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import org.w3c.dom.Node;

public class XMLSignatureValidator {
    private PublicKey publicKey;
    private SystemContext systemContext;

    public XMLSignatureValidator(SystemContext context, PublicKey publicKey) {
        this.publicKey = publicKey;
        this.systemContext = context;
    }

    public boolean isValid(Node dsSignature) {
        try {
            DOMValidateContext context = new DOMValidateContext(this.publicKey, dsSignature);
            String providerName = System.getProperty("jsr105Provider", "org.jcp.xml.dsig.internal.dom.XMLDSigRI");
            XMLSignatureFactory factory = XMLSignatureFactory.getInstance("DOM", (Provider)Class.forName(providerName).newInstance());
            XMLSignature signature = factory.unmarshalXMLSignature(context);
            boolean coreValidity = signature.validate(context);
            if (!coreValidity) {
                boolean sv = signature.getSignatureValue().validate(context);
                String status = sv ? "OK" : "NOT OK";
                this.systemContext.getOutputterStrategy().write("check signature value element: " + status);
                Iterator<Reference> i = signature.getSignedInfo().getReferences().iterator();
                int j = 0;
                while (i.hasNext()) {
                    Reference ref = i.next();
                    boolean refValid = ref.validate(context);
                    String id = ref.getURI();
                    status = refValid ? "OK" : "NOT OK";
                    this.systemContext.getOutputterStrategy().write("check signature reference (" + j + ") with URI [" + id + "] validation status: " + status);
                    ++j;
                }
            }
            return coreValidity;
        }
        catch (Exception e) {
            this.systemContext.getOutputterStrategy().write("signature error: " + e.getMessage());
            return false;
        }
    }
}

