/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.edec.dsig.validator;

import ch.admin.bit.edec.dsig.context.SystemContext;
import ch.admin.bit.edec.dsig.validator.X509CRLValidator;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertStore;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Set;

public class X509CertificateValidator {
    private Date date = new Date();
    private X509CRL x509crl = null;
    private final X509Certificate caCert;
    private final SystemContext context;

    public X509CertificateValidator(SystemContext context, X509Certificate caCert) {
        this.caCert = caCert;
        this.context = context;
    }

    public void setX509crl(X509CRL x509crl) {
        this.x509crl = x509crl;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public boolean isValid(X509Certificate cert) {
        try {
            CertificateFactory cf = this.context.getProviderSelector().getCertificateFactory();
            ArrayList<X509Certificate> list = new ArrayList<X509Certificate>();
            list.add(this.caCert);
            list.add(cert);
            CollectionCertStoreParameters certStoreParams = new CollectionCertStoreParameters(list);
            CertStore certStore = this.context.getProviderSelector().getCertStore(certStoreParams);
            Set<TrustAnchor> trust = Collections.singleton(new TrustAnchor(this.caCert, null));
            PKIXParameters params = new PKIXParameters(trust);
            params.setRevocationEnabled(false);
            params.addCertStore(certStore);
            params.setDate(this.date);
            ArrayList<X509Certificate> certChain = new ArrayList<X509Certificate>();
            certChain.add(cert);
            CertPath certPath = cf.generateCertPath(certChain);
            CertPathValidator certPathValidator = this.context.getProviderSelector().getCertPathValidator();
            certPathValidator.validate(certPath, params);
            if (this.x509crl != null) {
                X509CRLValidator validator = new X509CRLValidator(this.x509crl);
                return validator.isValid(cert);
            }
            return true;
        }
        catch (Exception e) {
            this.context.getOutputterStrategy().write("certificate error: " + e.getMessage());
            return false;
        }
    }
}

