/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.edec.dsig.util;

import ch.admin.bit.edec.dsig.util.NamespaceContextImpl;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLUtil {
    private XMLUtil() {
    }

    public static Document read(String inputFile) throws SAXException, IOException, ParserConfigurationException {
        return XMLUtil.read(new FileInputStream(inputFile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document read(InputStream inputStream) throws SAXException, IOException, ParserConfigurationException {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        URL xsdUrl = XMLUtil.class.getResource("/xsd/edec_evv_root.xsd");
        Schema schema = schemaFactory.newSchema(xsdUrl);
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        builderFactory.setNamespaceAware(true);
        builderFactory.setSchema(schema);
        try {
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            Document document = builder.parse(inputStream);
            return document;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static Node extractX509Token(Document xmldoc) throws XPathExpressionException {
        XPath xpath = XPathFactory.newInstance().newXPath();
        NamespaceContextImpl nsc = new NamespaceContextImpl();
        xpath.setNamespaceContext(nsc);
        XPathExpression expr = xpath.compile("//wsse:Security/wsse:BinarySecurityToken");
        return (Node)expr.evaluate(xmldoc, XPathConstants.NODE);
    }

    public static Node extractDSignature(Document xmldoc) throws XPathExpressionException {
        XPath xpath = XPathFactory.newInstance().newXPath();
        NamespaceContextImpl nsc = new NamespaceContextImpl();
        xpath.setNamespaceContext(nsc);
        XPathExpression expr = xpath.compile("//wsse:Security/ds:Signature");
        return (Node)expr.evaluate(xmldoc, XPathConstants.NODE);
    }

    public static Node extractTimeStamp(Document xmldoc) throws XPathExpressionException {
        XPath xpath = XPathFactory.newInstance().newXPath();
        NamespaceContextImpl nsc = new NamespaceContextImpl();
        xpath.setNamespaceContext(nsc);
        XPathExpression expr = xpath.compile("//wsse:Security/wsu:Timestamp/wsu:Created");
        return (Node)expr.evaluate(xmldoc, XPathConstants.NODE);
    }

    public static Node extractDocumentInformation(Document xmldoc) throws XPathExpressionException {
        XPath xpath = XPathFactory.newInstance().newXPath();
        XPathExpression expr = xpath.compile("//*[local-name()='documentInformation']");
        return (Node)expr.evaluate(xmldoc, XPathConstants.NODE);
    }

    public static Node extractTraderDeclarationNumber(Document xmldoc) throws XPathExpressionException {
        XPath xpath = XPathFactory.newInstance().newXPath();
        XPathExpression expr = xpath.compile("//*[local-name()='traderDeclarationNumber']");
        return (Node)expr.evaluate(xmldoc, XPathConstants.NODE);
    }

    public static Node extractTraderReference(Document xmldoc) throws XPathExpressionException {
        XPath xpath = XPathFactory.newInstance().newXPath();
        XPathExpression expr = xpath.compile("//*[local-name()='traderReference']");
        return (Node)expr.evaluate(xmldoc, XPathConstants.NODE);
    }

    public static NodeList extractDeclaratTIN(Document xmldoc) throws XPathExpressionException {
        XPath xpath = XPathFactory.newInstance().newXPath();
        XPathExpression expr = xpath.compile("//*[local-name()='traderIdentificationNumber']");
        return (NodeList)expr.evaluate(xmldoc, XPathConstants.NODESET);
    }
}

