/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.edec.dsig.out;

import ch.admin.bit.edec.dsig.out.OutputterStrategy;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class StreamOutputter
implements OutputterStrategy {
    protected PrintWriter writer;

    public StreamOutputter(OutputStream os) {
        this.writer = new PrintWriter(os);
    }

    @Override
    public void write(String str) {
        this.writer.println(str);
    }

    @Override
    public void write(String prefix, X509Certificate cert) {
        if (cert != null) {
            this.writer.println(prefix + " issuer DN: " + cert.getIssuerDN());
            this.writer.println(prefix + " subject DN: " + cert.getSubjectDN());
            this.writer.println(prefix + " valid from: " + cert.getNotBefore());
            this.writer.println(prefix + " valid to: " + cert.getNotAfter());
        } else {
            this.writer.println(prefix + " NOT SET");
        }
    }

    @Override
    public void write(String prefix, X509CRL crl) {
        if (crl != null) {
            this.writer.println(prefix + " issuer DN: " + crl.getIssuerDN());
            this.writer.println(prefix + " valid from: " + crl.getThisUpdate());
            this.writer.println(prefix + " next update: " + crl.getNextUpdate());
        } else {
            this.writer.println(prefix + " NOT SET");
        }
    }

    @Override
    public void write(NodeList list) {
        if (list != null) {
            int size = list.getLength();
            for (int i = 0; i < size; ++i) {
                Node current = list.item(i);
                if (1 != current.getNodeType()) continue;
                this.writer.println(current.getLocalName() + ": " + current.getTextContent());
            }
        }
    }

    @Override
    public void write(Node node) {
        if (node != null) {
            this.writer.println(node.getLocalName() + ": " + node.getTextContent());
        }
    }

    @Override
    public void write(String prefix, Throwable ex) {
        if (ex != null) {
            this.writer.println(prefix + ": " + ex.toString());
            for (StackTraceElement ste : ex.getStackTrace()) {
                this.writer.println("   " + ste.toString());
            }
        }
    }

    @Override
    public void close() {
        this.writer.close();
    }
}

