/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.edec.dsig;

import ch.admin.bit.edec.dsig.Environment;
import ch.admin.bit.edec.dsig.ValidationResult;
import ch.admin.bit.edec.dsig.ValidationResultImpl;
import ch.admin.bit.edec.dsig.builder.X509CRLBuilder;
import ch.admin.bit.edec.dsig.builder.X509CertificateBuilder;
import ch.admin.bit.edec.dsig.context.ProviderSelectorImpl;
import ch.admin.bit.edec.dsig.context.SystemContext;
import ch.admin.bit.edec.dsig.context.SystemContextImpl;
import ch.admin.bit.edec.dsig.out.OutputterStrategy;
import ch.admin.bit.edec.dsig.out.StringBufferOutputter;
import ch.admin.bit.edec.dsig.util.XMLUtil;
import ch.admin.bit.edec.dsig.validator.X509CertificateValidator;
import ch.admin.bit.edec.dsig.validator.XMLSignatureValidator;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Date;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class SignatureValidator {
    private X509CRL x509crl;
    private X509Certificate ca;
    private final SystemContext systemContext = this.createSystemContext();

    public SignatureValidator(String caPath, String crlPath) {
        if (crlPath != null) {
            X509CRLBuilder crlBuilder = new X509CRLBuilder(this.systemContext);
            try {
                this.x509crl = crlBuilder.createCRLFromPath(crlPath);
            }
            catch (Exception ex) {
                throw new IllegalArgumentException(ex);
            }
        }
        X509CertificateBuilder certificateBuilder = new X509CertificateBuilder(this.systemContext);
        try {
            this.ca = certificateBuilder.createCertificateFromPath(caPath);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public SignatureValidator(X509Certificate certificate, X509CRL x509crl) {
        this.ca = certificate;
        this.x509crl = x509crl;
    }

    public ValidationResult validate(Document xmlDoc) {
        ValidationResultImpl result = new ValidationResultImpl();
        OutputterStrategy out = this.systemContext.getOutputterStrategy();
        try {
            out.write("signature validator version: " + Environment.getVersion());
            out.write("system jre version: " + System.getProperty("java.version"));
            out.write("system jre vendor: " + System.getProperty("java.vendor"));
            out.write("system jre home: " + System.getProperty("java.home"));
            out.write("system os: " + System.getProperty("os.name"));
            out.write("system os version: " + System.getProperty("os.version"));
            out.write("system java endorsed dirs: " + System.getProperty("java.endorsed.dirs"));
            X509CertificateBuilder certificateBuilder = new X509CertificateBuilder(this.systemContext);
            X509Certificate cert = certificateBuilder.createCertificate(XMLUtil.extractX509Token(xmlDoc).getTextContent());
            Node dsSignature = XMLUtil.extractDSignature(xmlDoc);
            X509CertificateValidator certificateValidator = new X509CertificateValidator(this.systemContext, this.ca);
            certificateValidator.setX509crl(this.x509crl);
            certificateValidator.setDate(new Date());
            if (!certificateValidator.isValid(cert)) {
                result.setValid(false);
                String msg = "Certificate Error\n" + out.toString();
                result.setMessage(msg);
                return result;
            }
            result.setValid(true);
            XMLSignatureValidator signatureValidator = new XMLSignatureValidator(this.systemContext, cert.getPublicKey());
            if (!signatureValidator.isValid(dsSignature)) {
                result.setValid(false);
                String msg = "Signature Error\n" + out.toString();
                result.setMessage(msg);
                return result;
            }
            result.setValid(true);
        }
        catch (Exception ex) {
            result.setValid(false);
            result.setException(ex);
            String msg = "Exception:\n" + ex.getMessage() + "\n" + out.toString();
            result.setMessage(msg);
        }
        return result;
    }

    private SystemContext createSystemContext() {
        SystemContextImpl contextImpl = new SystemContextImpl();
        contextImpl.setOutputterStrategy(new StringBufferOutputter());
        contextImpl.setProviderSelector(new ProviderSelectorImpl());
        return contextImpl;
    }
}

