/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.edec.dsig;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;

public class Environment {
    public static String EVV = "path.evv";
    public static String CRL = "path.crl";
    public static String CA = "path.ca";
    public static String WINDOW_HEIGHT = "window.height";
    public static String WINDOW_WIDTH = "window.width";
    public static String LAF = "laf";
    private static String VERSION = "development";
    private static String CONFIG_FILE = "evv-validator.cfg";

    public static String getVersion() {
        return VERSION;
    }

    public static String getHomeDirectory() {
        return System.getProperty("user.home");
    }

    public static String getLineSeparator() {
        return System.getProperty("line.separator");
    }

    public static String getFileSeparator() {
        return System.getProperty("file.separator");
    }

    public static Properties loadConfig() {
        try {
            Properties properties = new Properties();
            FileInputStream stream = new FileInputStream(Environment.getHomeDirectory() + Environment.getFileSeparator() + CONFIG_FILE);
            properties.load(stream);
            stream.close();
            return properties;
        }
        catch (Exception ex) {
            return new Properties();
        }
    }

    public static void saveConfig(Properties properties) {
        String file = Environment.getHomeDirectory() + Environment.getFileSeparator() + CONFIG_FILE;
        try {
            FileOutputStream stream = new FileOutputStream(file);
            properties.store(stream, "eVV Validator GUI config file");
            stream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Image getImage(String path) {
        InputStream is = Environment.class.getResourceAsStream(path);
        if (is == null) {
            return null;
        }
        try {
            BufferedImage img = ImageIO.read(is);
            is.close();
            return img;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static String getLicense() {
        try {
            InputStream is = Environment.class.getResourceAsStream("/LICENSE.txt");
            if (is == null) {
                return "";
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            String line = reader.readLine();
            StringBuilder builder = new StringBuilder();
            while (line != null) {
                builder.append(line);
                builder.append(Environment.getLineSeparator());
                line = reader.readLine();
            }
            reader.close();
            return builder.toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    public static void logError(String str) {
        System.err.println("ERROR: " + str);
    }

    public static ImageIcon createImageIcon(String path) {
        URL imgURL = Environment.class.getResource(path);
        if (imgURL != null) {
            return new ImageIcon(imgURL);
        }
        Environment.logError("Couldn't find file: " + path);
        return null;
    }

    static {
        try {
            VERSION = ResourceBundle.getBundle("version").getString("releaseVersion");
        }
        catch (Exception ex) {
            Environment.logError("version file not found");
        }
    }
}

