/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl;

import java.io.IOException;
import org.bouncycastle.tls.crypto.TlsCertificate;
import org.bouncycastle.tls.crypto.TlsCipher;
import org.bouncycastle.tls.crypto.TlsCryptoParameters;
import org.bouncycastle.tls.crypto.TlsSecret;
import org.bouncycastle.tls.crypto.impl.AbstractTlsCrypto;
import org.bouncycastle.util.Arrays;

public abstract class AbstractTlsSecret
implements TlsSecret {
    protected byte[] data;

    protected AbstractTlsSecret(byte[] byArray) {
        this.data = byArray;
    }

    protected void checkAlive() {
        if (this.data == null) {
            throw new IllegalStateException("Secret has already been extracted or destroyed");
        }
    }

    protected abstract AbstractTlsCrypto getCrypto();

    public TlsCipher createCipher(TlsCryptoParameters tlsCryptoParameters, int n, int n2) throws IOException {
        return this.getCrypto().createCipher(tlsCryptoParameters, n, n2);
    }

    public synchronized void destroy() {
        if (this.data != null) {
            Arrays.fill(this.data, (byte)0);
            this.data = null;
        }
    }

    public synchronized byte[] encrypt(TlsCertificate tlsCertificate) throws IOException {
        this.checkAlive();
        return this.getCrypto().createEncryptor(tlsCertificate).encrypt(this.data, 0, this.data.length);
    }

    public synchronized byte[] extract() {
        this.checkAlive();
        byte[] byArray = this.data;
        this.data = null;
        return byArray;
    }

    synchronized byte[] copyData() {
        return Arrays.clone(this.data);
    }
}

