/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.IOException;
import org.bouncycastle.tls.AbstractTlsClient;
import org.bouncycastle.tls.DefaultTlsDHConfigVerifier;
import org.bouncycastle.tls.DefaultTlsKeyExchangeFactory;
import org.bouncycastle.tls.TlsDHConfigVerifier;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsKeyExchange;
import org.bouncycastle.tls.TlsKeyExchangeFactory;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCrypto;
import org.bouncycastle.util.Arrays;

public abstract class DefaultTlsClient
extends AbstractTlsClient {
    protected static final int[] BASE_CIPHER_SUITES = new int[]{52393, 49195, 49187, 49161, 52392, 49199, 49191, 49171, 52394, 158, 103, 51, 156, 60, 47};
    protected TlsDHConfigVerifier dhConfigVerifier;
    protected int[] supportedCipherSuites;

    public DefaultTlsClient(TlsCrypto tlsCrypto) {
        this(tlsCrypto, new DefaultTlsKeyExchangeFactory(), new DefaultTlsDHConfigVerifier());
    }

    public DefaultTlsClient(TlsCrypto tlsCrypto, TlsKeyExchangeFactory tlsKeyExchangeFactory, TlsDHConfigVerifier tlsDHConfigVerifier) {
        super(tlsCrypto, tlsKeyExchangeFactory);
        this.dhConfigVerifier = tlsDHConfigVerifier;
        this.supportedCipherSuites = TlsUtils.getSupportedCipherSuites(tlsCrypto, BASE_CIPHER_SUITES);
    }

    public int[] getCipherSuites() {
        return Arrays.clone(this.supportedCipherSuites);
    }

    public TlsKeyExchange getKeyExchange() throws IOException {
        int n = TlsUtils.getKeyExchangeAlgorithm(this.selectedCipherSuite);
        switch (n) {
            case 7: 
            case 9: 
            case 11: {
                return this.createDHKeyExchange(n);
            }
            case 3: 
            case 5: {
                return this.createDHEKeyExchange(n);
            }
            case 16: 
            case 18: 
            case 20: {
                return this.createECDHKeyExchange(n);
            }
            case 17: 
            case 19: {
                return this.createECDHEKeyExchange(n);
            }
            case 1: {
                return this.createRSAKeyExchange();
            }
        }
        throw new TlsFatalAlert(80);
    }

    protected TlsKeyExchange createDHKeyExchange(int n) throws IOException {
        return this.keyExchangeFactory.createDHKeyExchangeClient(n, this.supportedSignatureAlgorithms, this.dhConfigVerifier);
    }

    protected TlsKeyExchange createDHEKeyExchange(int n) throws IOException {
        return this.keyExchangeFactory.createDHEKeyExchangeClient(n, this.supportedSignatureAlgorithms, this.dhConfigVerifier);
    }

    protected TlsKeyExchange createECDHKeyExchange(int n) throws IOException {
        return this.keyExchangeFactory.createECDHKeyExchangeClient(n, this.supportedSignatureAlgorithms, this.createECConfigVerifier(), this.clientECPointFormats, this.serverECPointFormats);
    }

    protected TlsKeyExchange createECDHEKeyExchange(int n) throws IOException {
        return this.keyExchangeFactory.createECDHEKeyExchangeClient(n, this.supportedSignatureAlgorithms, this.createECConfigVerifier(), this.clientECPointFormats, this.serverECPointFormats);
    }

    protected TlsKeyExchange createRSAKeyExchange() throws IOException {
        return this.keyExchangeFactory.createRSAKeyExchange(this.supportedSignatureAlgorithms);
    }
}

