package ch.admin.bit.edec.dsig.validator;

import ch.admin.bit.edec.dsig.TestUtil;
import ch.admin.bit.edec.dsig.builder.X509CertificateBuilder;
import ch.admin.bit.edec.dsig.context.SystemContext;
import ch.admin.bit.edec.dsig.util.XMLUtil;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

import java.security.cert.X509Certificate;

import static org.junit.Assert.assertTrue;

/**
 * Tests for the class {@link XMLSignatureValidator}.
 */
public class XMLSignatureValidatorTest {

  private XMLSignatureValidator validator;

  private Document document;

  @Before public void setUp() throws Exception {
    SystemContext systemContext = TestUtil.createSystemContext();

    document = XMLUtil.read(TestUtil.getFile(TestUtil.VALID_EVV));

    X509CertificateBuilder certBuilder = new X509CertificateBuilder(systemContext);
    X509Certificate x509 = certBuilder.createCertificate(XMLUtil.extractX509Token(document).getTextContent());

    validator = new XMLSignatureValidator(systemContext, x509.getPublicKey());
  }

  @Test public void testIsValid() throws Exception {
    Node dsSignature = XMLUtil.extractDSignature(document);
    assertTrue(validator.isValid(dsSignature));
  }

}
