package ch.admin.bit.edec.dsig.validator;

import ch.admin.bit.edec.dsig.TestUtil;
import ch.admin.bit.edec.dsig.builder.X509CRLBuilder;
import ch.admin.bit.edec.dsig.builder.X509CertificateBuilder;
import ch.admin.bit.edec.dsig.context.SystemContext;
import ch.admin.bit.edec.dsig.util.XMLUtil;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;

import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;

import static org.junit.Assert.assertTrue;

/**
 * Tests for the class {@link X509CertificateValidator}.
 */
public class X509CertificateValidatorTest {

  private X509CertificateValidator certValidator;

  private X509Certificate secTokenCert;

  private X509CRL swissGovCrl;

  @Before public void setUp() throws Exception {
    SystemContext systemContext = TestUtil.createSystemContext();

    X509CertificateBuilder certBuilder = new X509CertificateBuilder(systemContext);
    X509Certificate x509Certificate = certBuilder.createCertificateFromPath(TestUtil.getFile(TestUtil.SWISS_GOV_CA));

    Document document = XMLUtil.read(TestUtil.getFile(TestUtil.VALID_EVV));
    secTokenCert = certBuilder.createCertificate(XMLUtil.extractX509Token(document).getTextContent());

    certValidator = new X509CertificateValidator(systemContext, x509Certificate);

    X509CRLBuilder crlBuilder = new X509CRLBuilder(systemContext);
    swissGovCrl = crlBuilder.createCRLFromPath(TestUtil.getFile(TestUtil.SWISS_GOV_CRL));
  }

  @Test public void testIsValidWithoutCrl() {
    assertTrue(certValidator.isValid(secTokenCert));
  }

  @Test public void testIsValidWithCrl() {
    certValidator.setX509crl(swissGovCrl);
    assertTrue(certValidator.isValid(secTokenCert));
  }

}
