/*
 *  Name:    $Id: TestSignatureValidator.java,v 1.9 2010/03/23 11:22:11 t724w Exp $
 *
 *  Copyright 2009 Bundesamt für Informatik und Telekommunikation
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package ch.admin.bit.edec.dsig.test;

import ch.admin.bit.edec.dsig.SignatureValidator;
import ch.admin.bit.edec.dsig.ValidationResult;
import ch.admin.bit.edec.dsig.util.XMLUtil;
import ch.admin.bit.edec.evv.ui.EVVValidator;
import junit.framework.JUnit4TestAdapter;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

import javax.xml.parsers.ParserConfigurationException;
import java.io.File;
import java.io.IOException;

import static org.junit.Assert.*;

public class TestSignatureValidator {

  private final static String CORRECT_EVV = "src/test/resources/eVVResponse.xml";
  private final static String INVALID_EVV = "src/test/resources/eVVResponse_invalid.xml";
  private final static String SOAP_FAULT = "src/test/resources/test_error.xml";

  private SignatureValidator validator;
  private String caFile = "Swiss+Government+Regular+CA+01.cer";
  private String crlFile = "RegularCA01.crl";

  public static junit.framework.Test suite() {
    return new JUnit4TestAdapter(TestSignatureValidator.class);
  }

  @Before public void setUp() {
    validator = new SignatureValidator(getPath(caFile), getPath(crlFile));
  }

  @Ignore @Test public void test_roundtrip_correct_evv() throws Exception {

    ValidationResult result = validator.validate(createDocument(getPath(CORRECT_EVV)));

    assertTrue(result.isValid());
    assertNull(result.getException());
  }

  @Test public void test_roundtrip_invalid_evv() throws Exception {

    ValidationResult result = validator.validate(createDocument(getPath(INVALID_EVV)));

    assertFalse(result.isValid());
    assertNull(result.getException());
  }

  @Test public void test_roundtrip_exception() {

    ValidationResult result = validator.validate(null);

    assertFalse(result.isValid());
    assertNotNull(result.getException());
  }

  @Ignore @Test public void test_roundtrip_with_soap_fault() throws Exception {

    ValidationResult result = validator.validate(createDocument(getPath(SOAP_FAULT)));

    assertTrue(result.isValid());
    assertNull(result.getException());
  }

  @Ignore @Test public void testConsoleFromFile() {
    EVVValidator console = new EVVValidator();

    ValidationResult result = console.validateFromFile(getPath(CORRECT_EVV), getPath(caFile), null, null, null, false);

    assertTrue(result.isValid());
  }

  private String getPath(String fileName) {
    return new File(fileName).getAbsolutePath();
  }

  private Document createDocument(String path) throws ParserConfigurationException, SAXException, IOException {
    return XMLUtil.read(path);
  }

}
