/*
 *  Name:    $Id: FileInputChangedListener.java,v 1.4 2010/01/27 16:01:10 t724w Exp $
 * 
 *  Copyright 2009 Bundesamt für Informatik und Telekommunikation
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package ch.admin.bit.edec.evv.ui.swing;

/**
 * A Listener which notifies when a path was changed
 * 
 * @author mru
 * 
 */
public interface FileInputChangedListener {

	/**
	 * Notifies when path changes happens
	 * 
	 * @param path
	 *            the new path
	 * @param source
	 *            the source which was changed
	 */
	public void onFilePathChanged(String path, FileInputType source);

}
