/*
 *  Name:    $Id: StringBufferOutputter.java,v 1.4 2010/03/02 16:01:39 t724w Exp $
 * 
 *  Copyright 2009 Bundesamt für Informatik und Telekommunikation
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package ch.admin.bit.edec.dsig.out;

import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;

import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import ch.admin.bit.edec.dsig.Environment;

public class StringBufferOutputter implements OutputterStrategy {

	private StringBuilder builder = new StringBuilder();
	private final static String NEW_LINE = Environment.getLineSeparator();

	public void write(String str) {
		builder.append(str + NEW_LINE);
	}

	public void write(String prefix, X509Certificate cert) {
		builder.append(prefix + NEW_LINE);
		builder.append(cert.toString() + NEW_LINE);
	}

	public void write(String prefix, X509CRL crl) {
		builder.append(prefix + NEW_LINE);
		builder.append(crl.toString() + NEW_LINE);
	}

	public void write(NodeList list) {
		builder.append(list.toString() + NEW_LINE);
	}

	public void write(Node node) {
		builder.append(node.toString() + NEW_LINE);
	}

	public void write(String prefix, Throwable ex) {
		builder.append(prefix + NEW_LINE);
		builder.append(ex.toString() + NEW_LINE);
	}

	@Override
	public String toString() {
		return builder.toString();
	}

	public void close() {
		// not needed
	}

}
